/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.crud.exception.CrudDeleteException;
import dev.krud.crudframework.crud.handler.CrudCreateTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudHelper;
import dev.krud.crudframework.crud.handler.CrudSecurityHandler;
import dev.krud.crudframework.crud.hooks.create.CRUDOnCreateHook;
import dev.krud.crudframework.crud.hooks.create.from.CRUDOnCreateFromHook;
import dev.krud.crudframework.model.BaseCrudEntity;
import java.io.Serializable;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class CrudCreateTransactionalHandlerImpl
implements CrudCreateTransactionalHandler {
    private final CrudHelper crudHelper;
    private final CrudSecurityHandler crudSecurityHandler;

    public CrudCreateTransactionalHandlerImpl(CrudHelper crudHelper, CrudSecurityHandler crudSecurityHandler) {
        this.crudHelper = crudHelper;
        this.crudSecurityHandler = crudSecurityHandler;
    }

    @Override
    @Transactional(readOnly=false)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity createTransactional(Entity entity, List<CRUDOnCreateHook<ID, Entity>> onHooks) {
        for (CRUDOnCreateHook<ID, Entity> onHook : onHooks) {
            onHook.run(entity);
        }
        this.crudHelper.validate(entity);
        return this.crudHelper.getCrudDaoForEntity(entity.getClass()).saveOrUpdate(entity);
    }

    @Override
    @Transactional(readOnly=false)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity createFromTransactional(Object object, Class<Entity> clazz, List<CRUDOnCreateFromHook<ID, Entity>> onHooks) {
        BaseCrudEntity entity = (BaseCrudEntity)this.crudHelper.fill(object, clazz);
        if (entity.exists()) {
            throw new CrudDeleteException("Entity of type [ " + clazz.getSimpleName() + " ] with ID [ " + entity.getId() + " ] already exists and cannot be created");
        }
        for (CRUDOnCreateFromHook<ID, BaseCrudEntity> cRUDOnCreateFromHook : onHooks) {
            cRUDOnCreateFromHook.run(entity, object);
        }
        this.crudHelper.validate(entity);
        return (Entity)this.crudHelper.getCrudDaoForEntity(clazz).saveOrUpdate(entity);
    }
}

