/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.crud.exception.CrudCreateException;
import dev.krud.crudframework.crud.handler.CrudCreateHandler;
import dev.krud.crudframework.crud.handler.CrudCreateTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudHelper;
import dev.krud.crudframework.crud.handler.CrudSecurityHandler;
import dev.krud.crudframework.crud.hooks.HooksDTO;
import dev.krud.crudframework.crud.hooks.create.CRUDOnCreateHook;
import dev.krud.crudframework.crud.hooks.create.CRUDPostCreateHook;
import dev.krud.crudframework.crud.hooks.create.CRUDPreCreateHook;
import dev.krud.crudframework.crud.hooks.create.from.CRUDOnCreateFromHook;
import dev.krud.crudframework.crud.hooks.create.from.CRUDPostCreateFromHook;
import dev.krud.crudframework.crud.hooks.create.from.CRUDPreCreateFromHook;
import dev.krud.crudframework.crud.hooks.interfaces.CreateFromHooks;
import dev.krud.crudframework.crud.hooks.interfaces.CreateHooks;
import dev.krud.crudframework.crud.policy.PolicyRuleType;
import dev.krud.crudframework.exception.WrapException;
import dev.krud.crudframework.model.BaseCrudEntity;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@WrapException(value=CrudCreateException.class)
public class CrudCreateHandlerImpl
implements CrudCreateHandler {
    @Autowired
    private CrudHelper crudHelper;
    @Autowired
    private CrudCreateTransactionalHandler crudCreateTransactionalHandler;
    @Autowired
    private CrudSecurityHandler crudSecurityHandler;

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity createInternal(Entity entity, HooksDTO<CRUDPreCreateHook<ID, Entity>, CRUDOnCreateHook<ID, Entity>, CRUDPostCreateHook<ID, Entity>> hooks, boolean applyPolicies) {
        List<CreateHooks> createHooksList;
        Objects.requireNonNull(entity, "Entity cannot be null");
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePreRulesAndThrow(PolicyRuleType.CAN_CREATE, entity.getClass());
        }
        if ((createHooksList = this.crudHelper.getHooks(CreateHooks.class, entity.getClass())) != null && !createHooksList.isEmpty()) {
            for (CreateHooks createHooks : createHooksList) {
                hooks.getPreHooks().add(0, createHooks::preCreate);
                hooks.getOnHooks().add(0, createHooks::onCreate);
                hooks.getPostHooks().add(0, createHooks::postCreate);
            }
        }
        for (CRUDPreCreateHook cRUDPreCreateHook : hooks.getPreHooks()) {
            cRUDPreCreateHook.run(entity);
        }
        entity = this.crudCreateTransactionalHandler.createTransactional(entity, hooks.getOnHooks());
        for (CRUDPostCreateHook cRUDPostCreateHook : hooks.getPostHooks()) {
            cRUDPostCreateHook.run(entity);
        }
        return entity;
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity createFromInternal(Object object, Class<Entity> clazz, HooksDTO<CRUDPreCreateFromHook<ID, Entity>, CRUDOnCreateFromHook<ID, Entity>, CRUDPostCreateFromHook<ID, Entity>> hooks) {
        Objects.requireNonNull(object, "Object cannot be null");
        List<CreateFromHooks> createFromHooksList = this.crudHelper.getHooks(CreateFromHooks.class, clazz);
        if (createFromHooksList != null && !createFromHooksList.isEmpty()) {
            for (CreateFromHooks createFromHooks : createFromHooksList) {
                hooks.getPreHooks().add(0, createFromHooks::preCreateFrom);
                hooks.getOnHooks().add(0, createFromHooks::onCreateFrom);
                hooks.getPostHooks().add(0, createFromHooks::postCreateFrom);
            }
        }
        for (CRUDPreCreateFromHook cRUDPreCreateFromHook : hooks.getPreHooks()) {
            cRUDPreCreateFromHook.run(object);
        }
        this.crudHelper.validate(object);
        Entity entity = this.crudCreateTransactionalHandler.createFromTransactional(object, clazz, hooks.getOnHooks());
        for (CRUDPostCreateFromHook<ID, Entity> postHook : hooks.getPostHooks()) {
            postHook.run(entity);
        }
        return entity;
    }
}

