/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.configuration;

import dev.krud.crudframework.crud.cache.CacheManagerAdapter;
import dev.krud.crudframework.crud.configuration.properties.CrudFrameworkProperties;
import dev.krud.crudframework.crud.handler.CrudCreateHandler;
import dev.krud.crudframework.crud.handler.CrudCreateHandlerImpl;
import dev.krud.crudframework.crud.handler.CrudCreateTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudCreateTransactionalHandlerImpl;
import dev.krud.crudframework.crud.handler.CrudDao;
import dev.krud.crudframework.crud.handler.CrudDeleteHandler;
import dev.krud.crudframework.crud.handler.CrudDeleteHandlerImpl;
import dev.krud.crudframework.crud.handler.CrudDeleteTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudDeleteTransactionalHandlerImpl;
import dev.krud.crudframework.crud.handler.CrudHandler;
import dev.krud.crudframework.crud.handler.CrudHandlerImpl;
import dev.krud.crudframework.crud.handler.CrudHelper;
import dev.krud.crudframework.crud.handler.CrudHelperImpl;
import dev.krud.crudframework.crud.handler.CrudReadHandler;
import dev.krud.crudframework.crud.handler.CrudReadHandlerImpl;
import dev.krud.crudframework.crud.handler.CrudReadTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudReadTransactionalHandlerImpl;
import dev.krud.crudframework.crud.handler.CrudSecurityHandler;
import dev.krud.crudframework.crud.handler.CrudSecurityHandlerImpl;
import dev.krud.crudframework.crud.handler.CrudUpdateHandler;
import dev.krud.crudframework.crud.handler.CrudUpdateHandlerImpl;
import dev.krud.crudframework.crud.handler.CrudUpdateTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudUpdateTransactionalHandlerImpl;
import dev.krud.crudframework.crud.policy.Policy;
import dev.krud.crudframework.crud.security.PrincipalProvider;
import dev.krud.crudframework.exception.WrapExceptionAspect;
import dev.krud.crudframework.model.PersistentEntity;
import dev.krud.shapeshift.ShapeShift;
import dev.krud.shapeshift.ShapeShiftBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CrudFrameworkProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J4\u0010\u0007\u001a\u00020\b2\u000e\b\u0001\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u001bH\u0017J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J*\u0010\t\u001a\u00020\n2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001fH\u0017J\b\u0010$\u001a\u00020%H\u0017J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010(\u001a\u00020)H\u0017\u00a8\u0006*"}, d2={"Ldev/krud/crudframework/crud/configuration/CrudFrameworkConfiguration;", "", "()V", "crudCreateHandler", "Ldev/krud/crudframework/crud/handler/CrudCreateHandler;", "crudCreateTransactionalHandler", "Ldev/krud/crudframework/crud/handler/CrudCreateTransactionalHandler;", "crudHelper", "Ldev/krud/crudframework/crud/handler/CrudHelper;", "crudSecurityHandler", "Ldev/krud/crudframework/crud/handler/CrudSecurityHandler;", "crudDeleteHandler", "Ldev/krud/crudframework/crud/handler/CrudDeleteHandler;", "crudDeleteTransactionalHandler", "Ldev/krud/crudframework/crud/handler/CrudDeleteTransactionalHandler;", "crudHandler", "Ldev/krud/crudframework/crud/handler/CrudHandler;", "crudDaos", "", "Ldev/krud/crudframework/crud/handler/CrudDao;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "cacheManagerAdapter", "Ldev/krud/crudframework/crud/cache/CacheManagerAdapter;", "shapeShift", "Ldev/krud/shapeshift/ShapeShift;", "crudReadHandler", "Ldev/krud/crudframework/crud/handler/CrudReadHandler;", "crudReadTransactionalHandler", "Ldev/krud/crudframework/crud/handler/CrudReadTransactionalHandler;", "policies", "Lorg/springframework/beans/factory/ObjectProvider;", "Ldev/krud/crudframework/crud/policy/Policy;", "Ldev/krud/crudframework/model/PersistentEntity;", "principalProvider", "Ldev/krud/crudframework/crud/security/PrincipalProvider;", "crudUpdateHandler", "Ldev/krud/crudframework/crud/handler/CrudUpdateHandler;", "crudUpdateTransactionalHandler", "Ldev/krud/crudframework/crud/handler/CrudUpdateTransactionalHandler;", "wrapExceptionAspect", "Ldev/krud/crudframework/exception/WrapExceptionAspect;", "crud-framework-core"})
public class CrudFrameworkConfiguration {
    @Bean
    @NotNull
    public CrudHandler crudHandler() {
        return new CrudHandlerImpl();
    }

    @Bean
    @NotNull
    public CrudHelper crudHelper(@Autowired(required=false) @NotNull List<? extends CrudDao> crudDaos, @NotNull ApplicationContext applicationContext, @NotNull CacheManagerAdapter cacheManagerAdapter, @Autowired(required=false) @Nullable ShapeShift shapeShift) {
        Intrinsics.checkNotNullParameter(crudDaos, (String)"crudDaos");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)cacheManagerAdapter, (String)"cacheManagerAdapter");
        ShapeShift shapeShift2 = shapeShift;
        if (shapeShift2 == null) {
            shapeShift2 = new ShapeShiftBuilder().build();
        }
        return new CrudHelperImpl(crudDaos, applicationContext, cacheManagerAdapter, shapeShift2);
    }

    @Bean
    @NotNull
    public CrudCreateHandler crudCreateHandler() {
        return new CrudCreateHandlerImpl();
    }

    @Bean
    @NotNull
    public CrudCreateTransactionalHandler crudCreateTransactionalHandler(@NotNull CrudHelper crudHelper, @NotNull CrudSecurityHandler crudSecurityHandler) {
        Intrinsics.checkNotNullParameter((Object)crudHelper, (String)"crudHelper");
        Intrinsics.checkNotNullParameter((Object)crudSecurityHandler, (String)"crudSecurityHandler");
        return new CrudCreateTransactionalHandlerImpl(crudHelper, crudSecurityHandler);
    }

    @Bean
    @NotNull
    public CrudDeleteHandler crudDeleteHandler() {
        return new CrudDeleteHandlerImpl();
    }

    @Bean
    @NotNull
    public CrudDeleteTransactionalHandler crudDeleteTransactionalHandler(@NotNull CrudHelper crudHelper, @NotNull CrudSecurityHandler crudSecurityHandler) {
        Intrinsics.checkNotNullParameter((Object)crudHelper, (String)"crudHelper");
        Intrinsics.checkNotNullParameter((Object)crudSecurityHandler, (String)"crudSecurityHandler");
        return new CrudDeleteTransactionalHandlerImpl(crudHelper, crudSecurityHandler);
    }

    @Bean
    @NotNull
    public CrudUpdateHandler crudUpdateHandler() {
        return new CrudUpdateHandlerImpl();
    }

    @Bean
    @NotNull
    public CrudUpdateTransactionalHandler crudUpdateTransactionalHandler(@NotNull CrudHelper crudHelper, @NotNull CrudSecurityHandler crudSecurityHandler) {
        Intrinsics.checkNotNullParameter((Object)crudHelper, (String)"crudHelper");
        Intrinsics.checkNotNullParameter((Object)crudSecurityHandler, (String)"crudSecurityHandler");
        return new CrudUpdateTransactionalHandlerImpl(crudHelper, crudSecurityHandler);
    }

    @Bean
    @NotNull
    public CrudReadHandler crudReadHandler() {
        return new CrudReadHandlerImpl();
    }

    @Bean
    @NotNull
    public CrudReadTransactionalHandler crudReadTransactionalHandler(@NotNull CrudHelper crudHelper, @NotNull CrudSecurityHandler crudSecurityHandler) {
        Intrinsics.checkNotNullParameter((Object)crudHelper, (String)"crudHelper");
        Intrinsics.checkNotNullParameter((Object)crudSecurityHandler, (String)"crudSecurityHandler");
        return new CrudReadTransactionalHandlerImpl(crudHelper, crudSecurityHandler);
    }

    @Bean
    @NotNull
    public CrudSecurityHandler crudSecurityHandler(@NotNull ObjectProvider<Policy<PersistentEntity>> policies, @NotNull ObjectProvider<PrincipalProvider> principalProvider) {
        Intrinsics.checkNotNullParameter(policies, (String)"policies");
        Intrinsics.checkNotNullParameter(principalProvider, (String)"principalProvider");
        return new CrudSecurityHandlerImpl(policies, principalProvider);
    }

    @Bean
    @NotNull
    public WrapExceptionAspect wrapExceptionAspect() {
        return new WrapExceptionAspect();
    }
}

