/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.cache.adapter.inmemory;

import dev.krud.crudframework.crud.cache.CacheManagerAdapter;
import dev.krud.crudframework.crud.cache.CrudCache;
import dev.krud.crudframework.crud.cache.CrudCacheOptions;
import dev.krud.crudframework.crud.cache.adapter.inmemory.InMemoryCrudCache;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/krud/crudframework/crud/cache/adapter/inmemory/InMemoryCacheManagerAdapter;", "Ldev/krud/crudframework/crud/cache/CacheManagerAdapter;", "()V", "caches", "", "", "Ldev/krud/crudframework/crud/cache/CrudCache;", "createCache", "name", "options", "Ldev/krud/crudframework/crud/cache/CrudCacheOptions;", "getCache", "Companion", "crud-framework-core"})
public final class InMemoryCacheManagerAdapter
implements CacheManagerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, CrudCache> caches = new LinkedHashMap();
    private static final Logger log = LoggerFactory.getLogger(InMemoryCacheManagerAdapter.class);

    @Override
    @Nullable
    public CrudCache getCache(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        log.debug("Attempting to find cache with name [ " + name + " ]");
        CrudCache cache = this.caches.get(name);
        if (cache != null) {
            log.debug("Found cache with " + name);
        } else {
            log.debug("Did not find cache with " + name);
        }
        return cache;
    }

    @Override
    @NotNull
    public CrudCache createCache(@NotNull String name, @NotNull CrudCacheOptions options) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        log.debug("Attempting to create or return cache with name [ " + name + " ]");
        CrudCache crudCache = this.caches.computeIfAbsent(name, arg_0 -> InMemoryCacheManagerAdapter.createCache$lambda$0((Function1)new Function1<String, CrudCache>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final CrudCache invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                InMemoryCacheManagerAdapter.access$getLog$cp().debug("Cache with name [ " + this.$name + " ] did not exist, creating");
                return new InMemoryCrudCache();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)crudCache, (String)"name: String, options: C\u2026moryCrudCache()\n        }");
        return crudCache;
    }

    private static final CrudCache createCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CrudCache)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/krud/crudframework/crud/cache/adapter/inmemory/InMemoryCacheManagerAdapter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "crud-framework-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

