/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.cache.adapter.ehcache;

import dev.krud.crudframework.crud.cache.CacheManagerAdapter;
import dev.krud.crudframework.crud.cache.CrudCache;
import dev.krud.crudframework.crud.cache.CrudCacheOptions;
import dev.krud.crudframework.crud.cache.adapter.ehcache.CrudEhCacheImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/krud/crudframework/crud/cache/adapter/ehcache/EhCacheManagerAdapter;", "Ldev/krud/crudframework/crud/cache/CacheManagerAdapter;", "cacheManager", "Lnet/sf/ehcache/CacheManager;", "(Lnet/sf/ehcache/CacheManager;)V", "createCache", "Ldev/krud/crudframework/crud/cache/CrudCache;", "name", "", "options", "Ldev/krud/crudframework/crud/cache/CrudCacheOptions;", "getCache", "Companion", "crud-framework-core"})
public final class EhCacheManagerAdapter
implements CacheManagerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CacheManager cacheManager;
    private static final Logger log = LoggerFactory.getLogger(EhCacheManagerAdapter.class);

    public EhCacheManagerAdapter(@NotNull CacheManager cacheManager) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        this.cacheManager = cacheManager;
    }

    @Override
    @Nullable
    public CrudCache getCache(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Cache cache = this.cacheManager.getCache(name);
        if (cache == null) {
            return null;
        }
        Cache vendorCache = cache;
        return new CrudEhCacheImpl((Ehcache)vendorCache);
    }

    @Override
    @NotNull
    public CrudCache createCache(@NotNull String name, @NotNull CrudCacheOptions options) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        log.debug("Attempting to create cache with name [ " + name + " ] and options [ " + options + " ]");
        CacheConfiguration configuration = new CacheConfiguration(name, 0);
        Long timeToLiveSeconds = options.component1();
        Long timeToIdleSeconds = options.component2();
        Long maxEntries = options.component3();
        if (timeToLiveSeconds != null) {
            configuration.setTimeToLiveSeconds(timeToLiveSeconds.longValue());
        }
        if (timeToIdleSeconds != null) {
            configuration.setTimeToIdleSeconds(timeToIdleSeconds.longValue());
        }
        if (maxEntries != null) {
            configuration.setMaxEntriesLocalHeap(maxEntries.longValue());
        }
        Ehcache vendorCache = this.cacheManager.addCacheIfAbsent((Ehcache)new Cache(configuration));
        log.debug("Created cache with [ " + name + " ] and options [ " + options + " ]");
        Intrinsics.checkNotNullExpressionValue((Object)vendorCache, (String)"vendorCache");
        return new CrudEhCacheImpl(vendorCache);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/krud/crudframework/crud/cache/adapter/ehcache/EhCacheManagerAdapter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "crud-framework-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

