package dev.kaccelero.commons.repositories

import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.IContext
import dev.kaccelero.repositories.IChildModelRepository
import kotlin.js.JsExport

@JsExport
open class ListChildModelWithContextFromRepositoryUseCase<Model : IChildModel<*, *, *, ParentId>, ParentId>(
    private val repository: IChildModelRepository<Model, *, *, *, ParentId>,
) : IListChildModelWithContextUseCase<Model, ParentId> {

    override fun invoke(input1: ParentId, input2: IContext): List<Model> = repository.list(input1, input2)

}
