/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.nms.NMS;
import java.util.Collection;

public class ScoreHolderArgument
extends Argument {
    private final boolean single;

    public ScoreHolderArgument(String nodeName) {
        this(nodeName, ScoreHolderType.SINGLE);
    }

    public ScoreHolderArgument(String nodeName, ScoreHolderType type) {
        super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentScoreholder(type == ScoreHolderType.SINGLE));
        this.single = type == ScoreHolderType.SINGLE;
    }

    public boolean isSingle() {
        return this.single;
    }

    @Override
    public Class<?> getPrimitiveType() {
        return this.single ? String.class : Collection.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.SCORE_HOLDER;
    }

    public <CommandListenerWrapper> Object parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return this.single ? nms.getScoreHolderSingle(cmdCtx, key) : nms.getScoreHolderMultiple(cmdCtx, key);
    }

    public static enum ScoreHolderType {
        SINGLE,
        MULTIPLE;

    }
}

