/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.nms.NMS;
import org.bukkit.command.CommandSender;

public class CustomArgument<T>
extends Argument {
    private CustomArgumentInfoParser<T> infoParser;
    private boolean keyed;

    public CustomArgument(String nodeName, CustomArgumentInfoParser<T> parser) {
        this(nodeName, parser, false);
    }

    public CustomArgument(String nodeName, CustomArgumentInfoParser<T> parser, boolean keyed) {
        super(nodeName, keyed ? CommandAPIHandler.getInstance().getNMS()._ArgumentMinecraftKeyRegistered() : StringArgumentType.string());
        this.keyed = keyed;
        this.infoParser = parser;
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public Class<T> getPrimitiveType() {
        return null;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.CUSTOM;
    }

    public <CommandListenerWrapper> Object parseCustomArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key, Object[] previousArguments) throws CommandSyntaxException {
        String customresult = this.keyed ? nms.getKeyedAsString(cmdCtx, key) : (String)cmdCtx.getArgument(key, String.class);
        try {
            CustomArgumentInfo info = new CustomArgumentInfo(nms.getCommandSenderFromCSS(cmdCtx.getSource()), previousArguments, customresult);
            return this.infoParser.apply(info);
        }
        catch (CustomArgumentException e) {
            throw e.toCommandSyntax(customresult, cmdCtx);
        }
        catch (Exception e) {
            String errorMsg = new MessageBuilder("Error in executing command ").appendFullInput().append(" - ").appendArgInput().appendHere().toString().replace("%input%", customresult).replace("%finput%", cmdCtx.getInput());
            throw new SimpleCommandExceptionType(() -> errorMsg).create();
        }
    }

    public <CommandListenerWrapper> Object parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        throw new RuntimeException("parseArgument() is not implemented for CustomArgument. Did you mean parseCustomArgument()?");
    }

    @FunctionalInterface
    public static interface CustomArgumentInfoParser<T> {
        public T apply(CustomArgumentInfo var1) throws CustomArgumentException;
    }

    public record CustomArgumentInfo(CommandSender sender, Object[] previousArgs, String input) {
    }

    public static class CustomArgumentException
    extends Exception {
        final String errorMessage;
        final MessageBuilder errorMessageBuilder;

        public CustomArgumentException(String errorMessage) {
            this.errorMessage = errorMessage;
            this.errorMessageBuilder = null;
        }

        public CustomArgumentException(MessageBuilder errorMessage) {
            this.errorMessage = null;
            this.errorMessageBuilder = errorMessage;
        }

        public CommandSyntaxException toCommandSyntax(String result, CommandContext<?> cmdCtx) {
            if (this.errorMessage == null) {
                String errorMsg = this.errorMessageBuilder.toString().replace("%input%", result).replace("%finput%", cmdCtx.getInput());
                return new SimpleCommandExceptionType(() -> errorMsg).create();
            }
            return new SimpleCommandExceptionType((Message)new LiteralMessage(this.errorMessage)).create();
        }
    }

    public static class MessageBuilder {
        StringBuilder builder;

        public MessageBuilder() {
            this.builder = new StringBuilder();
        }

        public MessageBuilder(String str) {
            this.builder = new StringBuilder(str);
        }

        public MessageBuilder appendArgInput() {
            this.builder.append("%input%");
            return this;
        }

        public MessageBuilder appendFullInput() {
            this.builder.append("%finput%");
            return this;
        }

        public MessageBuilder appendHere() {
            this.builder.append("<--[HERE]");
            return this;
        }

        public MessageBuilder append(String str) {
            this.builder.append(str);
            return this;
        }

        public MessageBuilder append(Object obj) {
            this.builder.append(obj);
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

