/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

class Config {
    private final boolean verboseOutput;
    private final boolean silentLogs;
    private final boolean useLatestNMSVersion;
    private final String message_missingExecutorImplementation;
    private final boolean createDispatcherFile;
    private final Map<JavaPlugin, String[]> pluginsToConvert;
    private final List<String> skipSenderProxy;
    private final List<String> commandsToConvert;

    public Config(FileConfiguration fileConfig) {
        this.verboseOutput = fileConfig.getBoolean("verbose-outputs");
        this.silentLogs = fileConfig.getBoolean("silent-logs");
        this.useLatestNMSVersion = fileConfig.getBoolean("use-latest-nms-version");
        this.message_missingExecutorImplementation = fileConfig.getString("messages.missing-executor-implementation");
        this.createDispatcherFile = fileConfig.getBoolean("create-dispatcher-json");
        this.pluginsToConvert = new HashMap<JavaPlugin, String[]>();
        this.skipSenderProxy = new ArrayList<String>();
        this.commandsToConvert = new ArrayList<String>();
        if (!fileConfig.getList("plugins-to-convert").isEmpty() && fileConfig.getMapList("plugins-to-convert").isEmpty()) {
            CommandAPI.getLog().severe("plugins-to-convert has an invalid type. Did you miss a colon (:) after a plugin name?");
        }
        for (Map map : fileConfig.getMapList("plugins-to-convert")) {
            String[] pluginCommands;
            if (map.values() == null || map.values().size() == 1 && map.values().iterator().next() == null) {
                pluginCommands = new String[]{};
            } else {
                List commands = (List)map.values().iterator().next();
                pluginCommands = commands.toArray(new String[0]);
            }
            String pluginName = (String)map.keySet().iterator().next();
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (plugin != null) {
                if (plugin instanceof JavaPlugin) {
                    JavaPlugin javaPlugin = (JavaPlugin)plugin;
                    this.pluginsToConvert.put(javaPlugin, pluginCommands);
                    continue;
                }
                new InvalidPluginException("Plugin " + pluginName + " is not a JavaPlugin!").printStackTrace();
                continue;
            }
            new InvalidPluginException("Could not find a plugin " + pluginName + "! Has it been loaded properly?").printStackTrace();
        }
        for (String pluginName : fileConfig.getStringList("skip-sender-proxy")) {
            if (Bukkit.getPluginManager().getPlugin(pluginName) != null) {
                this.skipSenderProxy.add(pluginName);
                continue;
            }
            new InvalidPluginException("Could not find a plugin " + pluginName + "! Has it been loaded properly?").printStackTrace();
        }
        for (String commandName : fileConfig.getStringList("other-commands-to-convert")) {
            this.commandsToConvert.add(commandName);
        }
    }

    public Config(boolean verbose) {
        this(new CommandAPIConfig().verboseOutput(verbose));
    }

    public Config(CommandAPIConfig config) {
        this.verboseOutput = config.verboseOutput;
        this.silentLogs = config.silentLogs;
        this.useLatestNMSVersion = config.useLatestNMSVersion;
        this.message_missingExecutorImplementation = config.missingExecutorImplementationMessage;
        this.createDispatcherFile = false;
        this.pluginsToConvert = new HashMap<JavaPlugin, String[]>();
        this.skipSenderProxy = new ArrayList<String>();
        this.commandsToConvert = new ArrayList<String>();
    }

    public boolean hasVerboseOutput() {
        return this.verboseOutput;
    }

    public boolean hasSilentLogs() {
        return this.silentLogs;
    }

    public boolean shouldUseLatestNMSVersion() {
        return this.useLatestNMSVersion;
    }

    public String getMissingImplementationMessage() {
        return this.message_missingExecutorImplementation;
    }

    public boolean willCreateDispatcherFile() {
        return this.createDispatcherFile;
    }

    public Set<Map.Entry<JavaPlugin, String[]>> getPluginsToConvert() {
        return this.pluginsToConvert.entrySet();
    }

    public boolean shouldSkipSenderProxy(Plugin plugin) {
        return this.skipSenderProxy.contains(plugin.getName());
    }

    public boolean shouldSkipSenderProxy(String commandName) {
        return this.skipSenderProxy.contains(commandName);
    }

    public List<String> getCommandsToConvert() {
        return this.commandsToConvert;
    }
}

