/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.SuggestionInfo;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@FunctionalInterface
public interface ArgumentSuggestions {
    public CompletableFuture<Suggestions> suggest(SuggestionInfo var1, SuggestionsBuilder var2) throws CommandSyntaxException;

    public static ArgumentSuggestions empty() {
        return (info, builder) -> builder.buildFuture();
    }

    public static ArgumentSuggestions strings(String ... suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromStrings(builder, suggestions));
    }

    public static ArgumentSuggestions strings(Collection<String> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromStrings(builder, suggestions));
    }

    public static ArgumentSuggestions strings(Function<SuggestionInfo, String[]> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromStrings(builder, (String[])suggestions.apply(info)));
    }

    public static ArgumentSuggestions stringCollection(Function<SuggestionInfo, Collection<String>> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromStrings(builder, (Collection)suggestions.apply(info)));
    }

    public static ArgumentSuggestions stringsAsync(Function<SuggestionInfo, CompletableFuture<String[]>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(strings -> ArgumentSuggestions.suggestionsFromStrings(builder, strings));
    }

    public static ArgumentSuggestions stringCollectionAsync(Function<SuggestionInfo, CompletableFuture<Collection<String>>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(strings -> ArgumentSuggestions.suggestionsFromStrings(builder, strings));
    }

    public static ArgumentSuggestions stringsWithTooltips(IStringTooltip ... suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromTooltips(builder, suggestions));
    }

    public static ArgumentSuggestions stringsWithTooltips(Collection<IStringTooltip> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromTooltips(builder, suggestions));
    }

    public static ArgumentSuggestions stringsWithTooltips(Function<SuggestionInfo, IStringTooltip[]> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromTooltips(builder, (IStringTooltip[])suggestions.apply(info)));
    }

    public static ArgumentSuggestions stringsWithTooltipsCollection(Function<SuggestionInfo, Collection<IStringTooltip>> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromTooltips(builder, (Collection)suggestions.apply(info)));
    }

    public static ArgumentSuggestions stringsWithTooltipsAsync(Function<SuggestionInfo, CompletableFuture<IStringTooltip[]>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(stringsWithTooltips -> ArgumentSuggestions.suggestionsFromTooltips(builder, stringsWithTooltips));
    }

    public static ArgumentSuggestions stringsWithTooltipsCollectionAsync(Function<SuggestionInfo, CompletableFuture<Collection<IStringTooltip>>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(stringsWithTooltips -> ArgumentSuggestions.suggestionsFromTooltips(builder, stringsWithTooltips));
    }

    public static ArgumentSuggestions merge(ArgumentSuggestions ... suggestions) {
        return (info, builder) -> {
            for (ArgumentSuggestions suggestion : suggestions) {
                suggestion.suggest(info, builder);
            }
            return builder.buildFuture();
        };
    }

    private static Suggestions suggestionsFromStrings(SuggestionsBuilder builder, String ... suggestions) {
        for (String suggestion : suggestions) {
            if (!ArgumentSuggestions.shouldSuggest(builder, suggestion)) continue;
            builder.suggest(suggestion);
        }
        return builder.build();
    }

    private static Suggestions suggestionsFromStrings(SuggestionsBuilder builder, Collection<String> suggestions) {
        for (String suggestion : suggestions) {
            if (!ArgumentSuggestions.shouldSuggest(builder, suggestion)) continue;
            builder.suggest(suggestion);
        }
        return builder.build();
    }

    private static Suggestions suggestionsFromTooltips(SuggestionsBuilder builder, IStringTooltip ... suggestions) {
        for (IStringTooltip suggestion : suggestions) {
            ArgumentSuggestions.processSuggestion(builder, suggestion);
        }
        return builder.build();
    }

    private static Suggestions suggestionsFromTooltips(SuggestionsBuilder builder, Collection<IStringTooltip> suggestions) {
        for (IStringTooltip suggestion : suggestions) {
            ArgumentSuggestions.processSuggestion(builder, suggestion);
        }
        return builder.build();
    }

    private static void processSuggestion(SuggestionsBuilder builder, IStringTooltip suggestion) {
        if (!ArgumentSuggestions.shouldSuggest(builder, suggestion.getSuggestion())) {
            return;
        }
        if (suggestion.getTooltip() == null) {
            builder.suggest(suggestion.getSuggestion());
        } else {
            builder.suggest(suggestion.getSuggestion(), suggestion.getTooltip());
        }
    }

    private static boolean shouldSuggest(SuggestionsBuilder builder, String suggestion) {
        return suggestion.toLowerCase(Locale.ROOT).startsWith(builder.getRemaining().toLowerCase(Locale.ROOT));
    }

    private static <T> CompletableFuture<T> future(T value) {
        return CompletableFuture.completedFuture(value);
    }
}

