/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.RootCommandNode;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import org.bukkit.command.CommandSender;

public final class Brigadier {
    private Brigadier() {
    }

    public static CommandDispatcher getCommandDispatcher() {
        return CommandAPIHandler.getInstance().DISPATCHER;
    }

    public static RootCommandNode getRootNode() {
        return Brigadier.getCommandDispatcher().getRoot();
    }

    public static LiteralArgumentBuilder fromLiteralArgument(LiteralArgument literalArgument) {
        return CommandAPIHandler.getInstance().getLiteralArgumentBuilderArgument(literalArgument.getLiteral(), literalArgument.getArgumentPermission(), literalArgument.getRequirements());
    }

    public static RedirectModifier fromPredicate(BiPredicate<CommandSender, Object[]> predicate, List<Argument> args) {
        return cmdCtx -> {
            if (predicate.test(Brigadier.getBukkitCommandSenderFromContext(cmdCtx), Brigadier.parseArguments(cmdCtx, args))) {
                return Collections.singleton(cmdCtx.getSource());
            }
            return Collections.emptyList();
        };
    }

    public static Command fromCommand(CommandAPICommand command) {
        try {
            return CommandAPIHandler.getInstance().generateCommand(command.getArguments().toArray(new Argument[0]), command.getExecutor(), command.isConverted());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RequiredArgumentBuilder fromArgument(List<Argument> args, String nodeName) {
        Argument[] argsArr = args.toArray(new Argument[0]);
        return CommandAPIHandler.getInstance().getRequiredArgumentBuilderDynamic(argsArr, CommandAPIHandler.getArgument(argsArr, nodeName));
    }

    public static RequiredArgumentBuilder fromArgument(Argument argument) {
        return CommandAPIHandler.getInstance().getRequiredArgumentBuilderDynamic(new Argument[]{argument}, argument);
    }

    public static SuggestionProvider toSuggestions(String nodeName, List<Argument> args) {
        return CommandAPIHandler.getInstance().toSuggestions(nodeName, args.toArray(new Argument[0]), true);
    }

    public static Object[] parseArguments(CommandContext cmdCtx, List<Argument> args) throws CommandSyntaxException {
        return CommandAPIHandler.getInstance().argsToObjectArr(cmdCtx, args.toArray(new Argument[0]));
    }

    public static Object getBrigadierSourceFromCommandSender(CommandSender sender) {
        return CommandAPIHandler.getInstance().getNMS().getCLWFromCommandSender(sender);
    }

    public static CommandSender getBukkitCommandSenderFromContext(CommandContext cmdCtx) {
        return CommandAPIHandler.getInstance().getNMS().getSenderForCommand(cmdCtx, false);
    }
}

