/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.wrappers;

import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.scoreboard.DisplaySlot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ScoreboardSlotWrapperTests {
    ScoreboardSlotWrapperTests() {
    }

    private DisplaySlot getNamedDisplaySlot(String name) {
        String nameNoTeam = name.replace("TEAM_", "");
        for (DisplaySlot slot : DisplaySlot.values()) {
            if (slot.name().equals(name)) {
                return slot;
            }
            if (!slot.name().equals(nameNoTeam)) continue;
            return slot;
        }
        throw new IllegalStateException("Can't find " + name + " in " + Arrays.stream(DisplaySlot.values()).map(Enum::name).collect(Collectors.joining(", ")));
    }

    @Test
    void testScoreboardSlotInternalMinecraft() {
        Assertions.assertEquals((Object)ScoreboardSlot.PLAYER_LIST, (Object)ScoreboardSlot.ofMinecraft((int)0));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR, (Object)ScoreboardSlot.ofMinecraft((int)1));
        Assertions.assertEquals((Object)ScoreboardSlot.BELOW_NAME, (Object)ScoreboardSlot.ofMinecraft((int)2));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_BLACK, (Object)ScoreboardSlot.ofMinecraft((int)3));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_BLUE, (Object)ScoreboardSlot.ofMinecraft((int)4));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_GREEN, (Object)ScoreboardSlot.ofMinecraft((int)5));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_AQUA, (Object)ScoreboardSlot.ofMinecraft((int)6));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_RED, (Object)ScoreboardSlot.ofMinecraft((int)7));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_PURPLE, (Object)ScoreboardSlot.ofMinecraft((int)8));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_GOLD, (Object)ScoreboardSlot.ofMinecraft((int)9));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_GRAY, (Object)ScoreboardSlot.ofMinecraft((int)10));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_GRAY, (Object)ScoreboardSlot.ofMinecraft((int)11));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_BLUE, (Object)ScoreboardSlot.ofMinecraft((int)12));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_GREEN, (Object)ScoreboardSlot.ofMinecraft((int)13));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_AQUA, (Object)ScoreboardSlot.ofMinecraft((int)14));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_RED, (Object)ScoreboardSlot.ofMinecraft((int)15));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_LIGHT_PURPLE, (Object)ScoreboardSlot.ofMinecraft((int)16));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_YELLOW, (Object)ScoreboardSlot.ofMinecraft((int)17));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_WHITE, (Object)ScoreboardSlot.ofMinecraft((int)18));
    }

    @Test
    void testScoreboardSlotOf() {
        Assertions.assertEquals((Object)ScoreboardSlot.PLAYER_LIST, (Object)ScoreboardSlot.of((DisplaySlot)DisplaySlot.PLAYER_LIST));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR, (Object)ScoreboardSlot.of((DisplaySlot)DisplaySlot.SIDEBAR));
        Assertions.assertEquals((Object)ScoreboardSlot.BELOW_NAME, (Object)ScoreboardSlot.of((DisplaySlot)DisplaySlot.BELOW_NAME));
        if (DisplaySlot.values().length > 3) {
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_BLACK, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_BLACK")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_BLUE, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_BLUE")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_GREEN, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_GREEN")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_AQUA, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_AQUA")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_RED, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_RED")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_PURPLE, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_PURPLE")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_GOLD, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_GOLD")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_GRAY, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_GRAY")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_GRAY, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_GRAY")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_BLUE, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_BLUE")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_GREEN, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_GREEN")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_AQUA, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_AQUA")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_RED, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_RED")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_LIGHT_PURPLE, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_LIGHT_PURPLE")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_YELLOW, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_YELLOW")));
            Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_WHITE, (Object)ScoreboardSlot.of((DisplaySlot)this.getNamedDisplaySlot("SIDEBAR_TEAM_WHITE")));
        }
    }

    @Test
    void testScoreboardSlotOfTeamColor() {
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_BLACK, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.BLACK));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_BLUE, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.DARK_BLUE));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_GREEN, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.DARK_GREEN));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_AQUA, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.DARK_AQUA));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_RED, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.DARK_RED));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_PURPLE, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.DARK_PURPLE));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_GOLD, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.GOLD));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_GRAY, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.GRAY));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_GRAY, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.DARK_GRAY));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_BLUE, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.BLUE));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_GREEN, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.GREEN));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_AQUA, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.AQUA));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_RED, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.RED));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_LIGHT_PURPLE, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.LIGHT_PURPLE));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_YELLOW, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.YELLOW));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR_TEAM_WHITE, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.WHITE));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.MAGIC));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.BOLD));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.STRIKETHROUGH));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.UNDERLINE));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.ITALIC));
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR, (Object)ScoreboardSlot.ofTeamColor((ChatColor)ChatColor.RESET));
    }

    @Test
    void testScoreboardSlotHasTeamColor() {
        Assertions.assertFalse((boolean)ScoreboardSlot.PLAYER_LIST.hasTeamColor());
        Assertions.assertFalse((boolean)ScoreboardSlot.SIDEBAR.hasTeamColor());
        Assertions.assertFalse((boolean)ScoreboardSlot.BELOW_NAME.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_BLACK.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_DARK_BLUE.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_DARK_GREEN.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_DARK_AQUA.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_DARK_RED.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_DARK_PURPLE.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_GOLD.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_GRAY.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_DARK_GRAY.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_BLUE.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_GREEN.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_AQUA.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_RED.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_LIGHT_PURPLE.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_YELLOW.hasTeamColor());
        Assertions.assertTrue((boolean)ScoreboardSlot.SIDEBAR_TEAM_WHITE.hasTeamColor());
    }

    @Test
    void testScoreboardSlotGetDisplaySlot() {
        Assertions.assertEquals((Object)DisplaySlot.PLAYER_LIST, (Object)ScoreboardSlot.PLAYER_LIST.getDisplaySlot());
        Assertions.assertEquals((Object)DisplaySlot.SIDEBAR, (Object)ScoreboardSlot.SIDEBAR.getDisplaySlot());
        Assertions.assertEquals((Object)DisplaySlot.BELOW_NAME, (Object)ScoreboardSlot.BELOW_NAME.getDisplaySlot());
        if (DisplaySlot.values().length > 3) {
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_BLACK"), (Object)ScoreboardSlot.SIDEBAR_TEAM_BLACK.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_BLUE"), (Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_BLUE.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_GREEN"), (Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_GREEN.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_AQUA"), (Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_AQUA.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_RED"), (Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_RED.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_PURPLE"), (Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_PURPLE.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_GOLD"), (Object)ScoreboardSlot.SIDEBAR_TEAM_GOLD.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_GRAY"), (Object)ScoreboardSlot.SIDEBAR_TEAM_GRAY.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_DARK_GRAY"), (Object)ScoreboardSlot.SIDEBAR_TEAM_DARK_GRAY.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_BLUE"), (Object)ScoreboardSlot.SIDEBAR_TEAM_BLUE.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_GREEN"), (Object)ScoreboardSlot.SIDEBAR_TEAM_GREEN.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_AQUA"), (Object)ScoreboardSlot.SIDEBAR_TEAM_AQUA.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_RED"), (Object)ScoreboardSlot.SIDEBAR_TEAM_RED.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_LIGHT_PURPLE"), (Object)ScoreboardSlot.SIDEBAR_TEAM_LIGHT_PURPLE.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_YELLOW"), (Object)ScoreboardSlot.SIDEBAR_TEAM_YELLOW.getDisplaySlot());
            Assertions.assertEquals((Object)this.getNamedDisplaySlot("SIDEBAR_TEAM_WHITE"), (Object)ScoreboardSlot.SIDEBAR_TEAM_WHITE.getDisplaySlot());
        }
    }
}

