/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.DoubleArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.exceptions.OptionalArgumentException;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class OptionalArgumentTests
extends TestBase {
    OptionalArgumentTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void testNormalArgument() {
        Mut type = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer((player, args) -> type.set((String)args.get("string")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test hello");
        this.server.dispatchCommand((CommandSender)player2, "test world");
        Assertions.assertEquals((Object)"hello", type.get());
        Assertions.assertEquals((Object)"world", type.get());
    }

    @Test
    void testOptionalArgument() {
        Mut type = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withOptionalArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer((player, args) -> type.set((String)args.get("string")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test");
        this.server.dispatchCommand((CommandSender)player2, "test hello");
        Assertions.assertNull(type.get());
        Assertions.assertEquals((Object)"hello", type.get());
    }

    @Test
    void testTwoOptionalArguments() {
        Mut type = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withOptionalArguments((AbstractArgument[])new Argument[]{new StringArgument("string1")})).withOptionalArguments((AbstractArgument[])new Argument[]{new StringArgument("string2")})).executesPlayer((player, args) -> {
            type.set((String)args.get("string1"));
            type.set((String)args.get("string2"));
        })).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test");
        Assertions.assertNull(type.get());
        Assertions.assertNull(type.get());
        this.server.dispatchCommand((CommandSender)player2, "test hello");
        Assertions.assertEquals((Object)"hello", type.get());
        Assertions.assertNull(type.get());
        this.server.dispatchCommand((CommandSender)player2, "test hello world");
        Assertions.assertEquals((Object)"hello", type.get());
        Assertions.assertEquals((Object)"world", type.get());
    }

    @Test
    public void testOptionalArgumentException() {
        Mut type = Mut.of();
        Assertions.assertThrows(OptionalArgumentException.class, () -> ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withOptionalArguments((AbstractArgument[])new Argument[]{new StringArgument("string1")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("string2")})).executesPlayer((player, args) -> {
            type.set((String)args.get("string1"));
            type.set((String)args.get("string2"));
        })).register());
        Assertions.assertThrows(OptionalArgumentException.class, () -> ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withOptionalArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("string1").combineWith((AbstractArgument[])new Argument[]{new StringArgument("string2")})})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("string3")})).executesPlayer(P_EXEC)).register());
    }

    @Test
    void testOptionalArgumentDefault() {
        Mut type = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withOptionalArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer((player, args) -> type.set(args.getOptional("string").orElse("hello")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test");
        this.server.dispatchCommand((CommandSender)player2, "test world");
        Assertions.assertEquals((Object)"hello", type.get());
        Assertions.assertEquals((Object)"world", type.get());
    }

    @Test
    void testOptionalArgumentWithIndex() {
        Mut type = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withOptionalArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer((player, args) -> type.set((String)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test");
        this.server.dispatchCommand((CommandSender)player2, "test hello");
        Assertions.assertNull(type.get());
        Assertions.assertEquals((Object)"hello", type.get());
    }

    @Test
    void testOptionalArgumentDefaultWithIndex() {
        Mut type = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withOptionalArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer((player, args) -> type.set(args.getOptional(0).orElse("hello")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test");
        this.server.dispatchCommand((CommandSender)player2, "test world");
        Assertions.assertEquals((Object)"hello", type.get());
        Assertions.assertEquals((Object)"world", type.get());
    }

    @Test
    void testOptionalArgumentDefaultWithIndexWithSupplier() {
        Mut type = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withOptionalArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer((player, args) -> type.set(args.getOptional(0).orElse("hello")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test");
        this.server.dispatchCommand((CommandSender)player2, "test world");
        Assertions.assertEquals((Object)"hello", type.get());
        Assertions.assertEquals((Object)"world", type.get());
    }

    @Test
    void testCombinedOptionalArguments() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withOptionalArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("string").combineWith((AbstractArgument[])new Argument[]{new IntegerArgument("number")})})).withOptionalArguments((AbstractArgument[])new Argument[]{new DoubleArgument("double")})).executesPlayer(info -> {
            results.set(info.args().get("string"));
            results.set(info.args().get("number"));
            results.set(info.args().get("double"));
        })).register();
        PlayerMock player = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player, "test");
        Assertions.assertNull(results.get());
        Assertions.assertNull(results.get());
        Assertions.assertNull(results.get());
        this.assertCommandFailsWith((CommandSender)player, "test hello", "Unknown or incomplete command, see below for error at position 10: test hello<--[HERE]");
        this.server.dispatchCommand((CommandSender)player, "test hello 5");
        Assertions.assertEquals((Object)"hello", results.get());
        Assertions.assertEquals((Object)5, results.get());
        Assertions.assertNull(results.get());
        this.server.dispatchCommand((CommandSender)player, "test hello 5 6.0");
        Assertions.assertEquals((Object)"hello", results.get());
        Assertions.assertEquals((Object)5, results.get());
        Assertions.assertEquals((Object)6.0, results.get());
        this.assertNoMoreResults(results);
    }
}

