/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.AbstractArgumentTree;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandTree;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.Location2DArgument;
import dev.jorel.commandapi.arguments.LocationArgument;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.arguments.PlayerArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.CommandExecutor;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.Location2D;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class ArgumentTests
extends TestBase {
    ArgumentTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTest() {
        ((CommandAPICommand)new CommandAPICommand("test").executesPlayer((player, args) -> player.sendMessage("success"))).register();
        PlayerMock player2 = this.server.addPlayer();
        boolean commandResult = this.server.dispatchCommand((CommandSender)player2, "test");
        Assertions.assertTrue((boolean)commandResult);
        Assertions.assertEquals((Object)"success", (Object)player2.nextMessage());
    }

    @Test
    void executionTestWithStringArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("value")})).executesPlayer((player, args) -> {
            String value = (String)args.get(0);
            player.sendMessage("success " + value);
        })).register();
        PlayerMock player2 = this.server.addPlayer();
        boolean commandResult = this.server.dispatchCommand((CommandSender)player2, "test myvalue");
        Assertions.assertTrue((boolean)commandResult);
        Assertions.assertEquals((Object)"success myvalue", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"value\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
        this.server.dispatchCommand((CommandSender)player2, "test myvalue");
        Assertions.assertNotEquals((Object)"success blah", (Object)player2.nextMessage());
        Assertions.assertDoesNotThrow(() -> Assertions.assertTrue((boolean)this.server.dispatchThrowableCommand((CommandSender)player2, "test Hello")));
        Assertions.assertDoesNotThrow(() -> Assertions.assertTrue((boolean)this.server.dispatchThrowableCommand((CommandSender)player2, "test 123")));
        Assertions.assertDoesNotThrow(() -> Assertions.assertTrue((boolean)this.server.dispatchThrowableCommand((CommandSender)player2, "test hello123")));
        Assertions.assertDoesNotThrow(() -> Assertions.assertTrue((boolean)this.server.dispatchThrowableCommand((CommandSender)player2, "test Hello_world")));
        Assertions.assertEquals((Object)"success Hello", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"success 123", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"success hello123", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"success Hello_world", (Object)player2.nextMessage());
        this.assertInvalidSyntax((CommandSender)player2, "test hello@email.com");
        this.assertInvalidSyntax((CommandSender)player2, "test yesn't");
    }

    @Test
    void executionTestWithCommandTree() {
        Mut<String> result = Mut.of();
        ((CommandTree)((CommandTree)((CommandTree)new CommandTree("test").executes(this.givePosition("", result), new ExecutorType[0])).then(((Argument)((Argument)new LiteralArgument("1").executes(this.givePosition("1", result), new ExecutorType[0])).then(((Argument)((Argument)new LiteralArgument("1").executes(this.givePosition("11", result), new ExecutorType[0])).then((AbstractArgumentTree)new LiteralArgument("1").executes(this.givePosition("111", result), new ExecutorType[0]))).then((AbstractArgumentTree)new LiteralArgument("2").executes(this.givePosition("112", result), new ExecutorType[0])))).then(((Argument)((Argument)new LiteralArgument("2").executes(this.givePosition("12", result), new ExecutorType[0])).then((AbstractArgumentTree)new LiteralArgument("1").executes(this.givePosition("121", result), new ExecutorType[0]))).then((AbstractArgumentTree)new LiteralArgument("2").executes(this.givePosition("122", result), new ExecutorType[0]))))).then(((Argument)((Argument)new LiteralArgument("2").executes(this.givePosition("2", result), new ExecutorType[0])).then(((Argument)((Argument)new LiteralArgument("1").executes(this.givePosition("21", result), new ExecutorType[0])).then((AbstractArgumentTree)new LiteralArgument("1").executes(this.givePosition("211", result), new ExecutorType[0]))).then((AbstractArgumentTree)new LiteralArgument("2").executes(this.givePosition("212", result), new ExecutorType[0])))).then(((Argument)((Argument)new LiteralArgument("2").executes(this.givePosition("22", result), new ExecutorType[0])).then((AbstractArgumentTree)new LiteralArgument("1").executes(this.givePosition("221", result), new ExecutorType[0]))).then((AbstractArgumentTree)new LiteralArgument("2").executes(this.givePosition("222", result), new ExecutorType[0]))))).register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"1\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              },\n              \"executable\": true\n            },\n            \"2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              },\n              \"executable\": true\n            }\n          },\n          \"executable\": true\n        },\n        \"2\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              },\n              \"executable\": true\n            },\n            \"2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              },\n              \"executable\": true\n            }\n          },\n          \"executable\": true\n        }\n      },\n      \"executable\": true\n    }\n  }\n}", (Object)this.getDispatcherString());
        PlayerMock sender = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)sender, "test");
        this.server.dispatchCommand((CommandSender)sender, "test 1");
        this.server.dispatchCommand((CommandSender)sender, "test 1 1");
        this.server.dispatchCommand((CommandSender)sender, "test 1 1 1");
        this.server.dispatchCommand((CommandSender)sender, "test 1 1 2");
        this.server.dispatchCommand((CommandSender)sender, "test 1 2");
        this.server.dispatchCommand((CommandSender)sender, "test 1 2 1");
        this.server.dispatchCommand((CommandSender)sender, "test 1 2 2");
        this.server.dispatchCommand((CommandSender)sender, "test 2");
        this.server.dispatchCommand((CommandSender)sender, "test 2 1");
        this.server.dispatchCommand((CommandSender)sender, "test 2 1 1");
        this.server.dispatchCommand((CommandSender)sender, "test 2 1 2");
        this.server.dispatchCommand((CommandSender)sender, "test 2 2");
        this.server.dispatchCommand((CommandSender)sender, "test 2 2 1");
        this.server.dispatchCommand((CommandSender)sender, "test 2 2 2");
        Assertions.assertEquals((Object)"", (Object)result.get());
        Assertions.assertEquals((Object)"1", (Object)result.get());
        Assertions.assertEquals((Object)"11", (Object)result.get());
        Assertions.assertEquals((Object)"111", (Object)result.get());
        Assertions.assertEquals((Object)"112", (Object)result.get());
        Assertions.assertEquals((Object)"12", (Object)result.get());
        Assertions.assertEquals((Object)"121", (Object)result.get());
        Assertions.assertEquals((Object)"122", (Object)result.get());
        Assertions.assertEquals((Object)"2", (Object)result.get());
        Assertions.assertEquals((Object)"21", (Object)result.get());
        Assertions.assertEquals((Object)"211", (Object)result.get());
        Assertions.assertEquals((Object)"212", (Object)result.get());
        Assertions.assertEquals((Object)"22", (Object)result.get());
        Assertions.assertEquals((Object)"221", (Object)result.get());
        Assertions.assertEquals((Object)"222", (Object)result.get());
    }

    private CommandExecutor givePosition(String pos, Mut<String> result) {
        return (sender, args) -> result.set(pos);
    }

    @Test
    void executionTestWithLocationArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("loc3").withArguments((AbstractArgument[])new Argument[]{new LocationArgument("value", LocationType.PRECISE_POSITION)})).executesPlayer((player, args) -> {
            Location value = (Location)args.get(0);
            player.sendMessage(value.getX() + ", " + value.getY() + ", " + value.getZ());
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("loc3b").withArguments((AbstractArgument[])new Argument[]{new LocationArgument("value", LocationType.BLOCK_POSITION)})).executesPlayer((player, args) -> {
            Location value = (Location)args.get(0);
            player.sendMessage(value.getX() + ", " + value.getY() + ", " + value.getZ());
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("loc2").withArguments((AbstractArgument[])new Argument[]{new Location2DArgument("value", LocationType.PRECISE_POSITION)})).executesPlayer((player, args) -> {
            Location2D value = (Location2D)args.get(0);
            player.sendMessage(value.getX() + ", " + value.getZ());
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("loc2b").withArguments((AbstractArgument[])new Argument[]{new Location2DArgument("value", LocationType.BLOCK_POSITION)})).executesPlayer((player, args) -> {
            Location2D value = (Location2D)args.get(0);
            player.sendMessage(value.getX() + ", " + value.getZ());
        })).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "loc3 1 10 15");
        this.server.dispatchCommand((CommandSender)player2, "loc3b 1 10 15");
        this.server.dispatchCommand((CommandSender)player2, "loc2 1 15");
        this.server.dispatchCommand((CommandSender)player2, "loc2b 1 15");
        Assertions.assertEquals((Object)"1.5, 10.0, 15.5", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"1.0, 10.0, 15.0", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"1.5, 15.5", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"1.0, 15.0", (Object)player2.nextMessage());
        player2.setLocation(new Location((World)new WorldMock(), 2.0, 2.0, 2.0));
        this.server.dispatchCommand((CommandSender)player2, "loc3 ~ ~5 ~");
        this.server.dispatchCommand((CommandSender)player2, "loc3b ~ ~5 ~");
        this.server.dispatchCommand((CommandSender)player2, "loc2 ~ ~5");
        this.server.dispatchCommand((CommandSender)player2, "loc2b ~ ~5");
        Assertions.assertEquals((Object)"2.0, 7.0, 2.0", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"2.0, 7.0, 2.0", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"2.0, 7.0", (Object)player2.nextMessage());
        Assertions.assertEquals((Object)"2.0, 7.0", (Object)player2.nextMessage());
    }

    @RepeatedTest(value=10)
    void executionTestWithGreedyStringArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("value")})).executesPlayer((player, args) -> {
            String value = (String)args.get(0);
            player.sendMessage(value);
        })).register();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            builder.append((char)ThreadLocalRandom.current().nextInt(32, 127));
        }
        String stringArgValue = builder.toString();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test " + stringArgValue);
        Assertions.assertEquals((Object)stringArgValue, (Object)player2.nextMessage());
    }

    @Test
    void executionTestWithPlayerArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).executesPlayer((player, args) -> results.set((Player)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test APlayer");
        Assertions.assertEquals((Object)player2, results.get());
        this.assertInvalidSyntax((CommandSender)player2, "test BPlayer");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTwoCommandsSameArgumentDifferentName() {
        Mut str1 = Mut.of();
        Mut str2 = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("str_1")})).executesPlayer((player, args) -> str1.set((String)args.get(0)))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("str_2")})).executesPlayer((player, args) -> str2.set((String)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test hello");
        this.server.dispatchCommand((CommandSender)player2, "test world");
        Assertions.assertEquals((Object)"hello", str1.get());
        Assertions.assertEquals((Object)"world", str1.get());
    }

    @Test
    void executionTwoCommandsSameArgumentDifferentNameDifferentImplementation() {
        Mut int1 = Mut.of();
        Mut int2 = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("int_1", 1, 10)})).executesPlayer((player, args) -> int1.set(Integer.valueOf((Integer)args.get(0))))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("str_2", 50, 100)})).executesPlayer((player, args) -> int2.set(Integer.valueOf((Integer)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test 5");
        this.server.dispatchCommand((CommandSender)player2, "test 60");
        Assertions.assertEquals((int)5, (Integer)((Integer)int1.get()));
        Assertions.assertEquals((int)60, (Integer)((Integer)int2.get()));
    }

    @Test
    void executionTwoCommandsSameArgumentDifferentNameDifferentImplementation2() {
        Mut int1 = Mut.of();
        Mut int2 = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("int_1", 1, 100)})).executesPlayer((player, args) -> int1.set(Integer.valueOf((Integer)args.get(0))))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("str_2", 50, 100)})).executesPlayer((player, args) -> int2.set(Integer.valueOf((Integer)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test 5");
        this.server.dispatchCommand((CommandSender)player2, "test 60");
        Assertions.assertEquals((int)5, (Integer)((Integer)int1.get()));
        Assertions.assertEquals((int)60, (Integer)((Integer)int1.get()));
        this.assertNoMoreResults(int1);
        this.assertNoMoreResults(int2);
    }
}

