/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.TeamArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.scoreboard.Team;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentTeamTests
extends TestBase {
    ArgumentTeamTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithTeamArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new TeamArgument("team")})).executesPlayer((player, args) -> results.set((Team)args.get("team")))).register();
        PlayerMock player2 = this.server.addPlayer();
        Bukkit.getScoreboardManager().getMainScoreboard().registerNewTeam("myteam");
        Team myTeam = Bukkit.getScoreboardManager().getMainScoreboard().getTeam("myteam");
        this.server.dispatchCommand((CommandSender)player2, "test myteam");
        Assertions.assertEquals((Object)myTeam, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test blah", "Unknown team 'blah'");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithTeamArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new TeamArgument("team")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Bukkit.getScoreboardManager().getMainScoreboard().registerNewTeam("myteam");
        Bukkit.getScoreboardManager().getMainScoreboard().registerNewTeam("my_other_team");
        Assertions.assertEquals(List.of("my_other_team", "myteam"), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

