/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ScoreHolderArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentScoreHolderTests
extends TestBase {
    ArgumentScoreHolderTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithScoreHolderArgumentSingle() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ScoreHolderArgument.Single("holder")})).executesPlayer((player, args) -> results.set((String)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test APlayer");
        Assertions.assertEquals((Object)"APlayer", results.get());
        UUID uuid = UUID.randomUUID();
        this.server.dispatchCommand((CommandSender)player2, "test " + String.valueOf(uuid));
        Assertions.assertEquals((Object)uuid.toString(), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test @e[type=player,scores={deaths=..9},limit=1]", "Selector not allowed");
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            this.assertCommandFailsWith((CommandSender)player2, "test @e[type=player,scores={deaths=..9}]", "Only one entity is allowed, but the provided selector allows more than one at position 40: ...aths=..9}]<--[HERE]");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test @e[type=player,scores={deaths=..9}]", "Only one entity is allowed, but the provided selector allows more than one");
        }
        player2.setOp(true);
        this.assertCommandFailsWith((CommandSender)player2, "test @e[type=player,scores={deaths=..9},limit=1]", "No entity was found");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithScoreHolderArgumentMultiple() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ScoreHolderArgument.Multiple("holder")})).executesPlayer((player, args) -> results.set((Collection)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test APlayer");
        Assertions.assertIterableEquals(Set.of("APlayer"), (Iterable)((Iterable)results.get()));
        UUID uuid = UUID.randomUUID();
        this.server.dispatchCommand((CommandSender)player2, "test " + String.valueOf(uuid));
        Assertions.assertIterableEquals(Set.of(uuid.toString()), (Iterable)((Iterable)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test @e[type=player,scores={deaths=..9},limit=1]", "Selector not allowed");
        this.assertCommandFailsWith((CommandSender)player2, "test @e[type=player,scores={deaths=..9}]", "Selector not allowed");
        player2.setOp(true);
        this.assertCommandFailsWith((CommandSender)player2, "test @e[type=player,scores={deaths=..9},limit=1]", "No entity was found");
        this.assertCommandFailsWith((CommandSender)player2, "test @e[type=player,scores={deaths=..9}]", "No entity was found");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithScoreHolderArgumentSingle() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ScoreHolderArgument.Single("holder")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertIterableEquals(Set.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void suggestionTestWithScoreHolderArgumentMultiple() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ScoreHolderArgument.Multiple("holder")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertIterableEquals(Set.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

