/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ParticleArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.ParticleData;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Snowable;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class ArgumentParticleTests
extends TestBase {
    private Set<Particle> dodgyParticles = Set.of(Particle.SNOW_SHOVEL, Particle.SUSPENDED_DEPTH);

    ArgumentParticleTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    private float round(float value, int n) {
        return (float)((double)Math.round((double)value * Math.pow(10.0, n)) / Math.pow(10.0, n));
    }

    @Test
    void executionTestWithParticleArgumentVoid() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (Particle particle : Particle.values()) {
            String particleName;
            if (!particle.getDataType().equals(Void.class) || this.dodgyParticles.contains(particle) || this.version.greaterThanOrEqualTo(MCVersion.V1_20_5) && particle.name().equals("SPELL_MOB") || (particleName = MockPlatform.getInstance().getNMSParticleNameFromBukkit(particle)) == null) continue;
            this.server.dispatchCommand((CommandSender)player2, "test " + particleName);
            Assertions.assertEquals((Object)particle, (Object)((ParticleData)results.get()).particle());
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentDust() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            this.server.dispatchCommand((CommandSender)player2, "test dust{color:[1.0f,0.5f,0.0f],scale:4.0f}");
        } else {
            this.server.dispatchCommand((CommandSender)player2, "test dust 1 0.5 0 4");
        }
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.REDSTONE, (Object)result.particle());
        Assertions.assertEquals((float)4.0f, (float)((Particle.DustOptions)result.data()).getSize());
        Assertions.assertEquals((Object)Color.fromRGB((int)255, (int)127, (int)0), (Object)((Particle.DustOptions)result.data()).getColor());
        this.assertNoMoreResults(results);
    }

    @RepeatedTest(value=10)
    void executionTestWithParticleArgumentDustRandom() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        float red = this.round(ThreadLocalRandom.current().nextFloat(), 2);
        float green = this.round(ThreadLocalRandom.current().nextFloat(), 2);
        float blue = this.round(ThreadLocalRandom.current().nextFloat(), 2);
        int size = ThreadLocalRandom.current().nextInt(1, 5);
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            this.server.dispatchCommand((CommandSender)player2, "test dust{color:[%sf,%sf,%sf],scale:%d.0f}".formatted(Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), size));
        } else {
            this.server.dispatchCommand((CommandSender)player2, "test dust %s %s %s %d".formatted(Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), size));
        }
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.REDSTONE, (Object)result.particle());
        Assertions.assertEquals((float)size, (float)((Particle.DustOptions)result.data()).getSize());
        Assertions.assertEquals((Object)Color.fromRGB((int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f))), (Object)((Particle.DustOptions)result.data()).getColor());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentDustColorTransition() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            this.server.dispatchCommand((CommandSender)player2, "test dust_color_transition{from_color:[0.1,0.2,0.3],scale:0.4,to_color:[0.5,0.6,0.7]}");
        } else {
            this.server.dispatchCommand((CommandSender)player2, "test dust_color_transition 0.1 0.2 0.3 0.4 0.5 0.6 0.7");
        }
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.DUST_COLOR_TRANSITION, (Object)result.particle());
        Assertions.assertEquals((Object)Color.fromRGB((int)25, (int)51, (int)76), (Object)((Particle.DustTransition)result.data()).getColor());
        Assertions.assertEquals((float)0.4f, (float)((Particle.DustTransition)result.data()).getSize());
        Assertions.assertEquals((Object)Color.fromRGB((int)127, (int)153, (int)178), (Object)((Particle.DustTransition)result.data()).getToColor());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentBlock() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            this.server.dispatchCommand((CommandSender)player2, "test block{block_state:{Name:\"minecraft:grass_block\",Properties:{snowy:\"true\"}}}");
        } else {
            this.server.dispatchCommand((CommandSender)player2, "test block minecraft:grass_block[snowy=true]");
        }
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.BLOCK_CRACK, (Object)result.particle());
        Assertions.assertEquals((Object)Material.GRASS_BLOCK, (Object)((BlockData)result.data()).getMaterial());
        Assertions.assertTrue((boolean)((Snowable)result.data()).isSnowy());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentItem() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            this.server.dispatchCommand((CommandSender)player2, "test item{item:\"apple\"}");
        } else {
            this.server.dispatchCommand((CommandSender)player2, "test item apple");
        }
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.ITEM_CRACK, (Object)result.particle());
        Assertions.assertEquals((Object)new ItemStack(Material.APPLE), (Object)((ItemStack)result.data()));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentEntityEffect() {
        Assumptions.assumeTrue((boolean)this.version.greaterThanOrEqualTo(MCVersion.V1_20_5));
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.getUnchecked("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test entity_effect{color:[1.0,0.0,0.0,1.0]}");
        ParticleData result = (ParticleData)results.get();
        Assumptions.assumeFalse((boolean)Bukkit.getBukkitVersion().equals("1.20.1-R0.1-SNAPSHOT"));
        Assertions.assertEquals((Object)Particle.valueOf((String)"ENTITY_EFFECT"), (Object)result.particle());
        Assertions.assertEquals((int)255, (int)((Color)result.data()).getRed());
        Assertions.assertEquals((int)0, (int)((Color)result.data()).getGreen());
        Assertions.assertEquals((int)0, (int)((Color)result.data()).getBlue());
        Assertions.assertEquals((int)255, (int)((Color)result.data()).getAlpha());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentVibration() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            this.server.dispatchCommand((CommandSender)player2, "test vibration{destination:{type:\"block\",pos:[1.0,2.0,3.0]},arrival_in_ticks:4}");
        } else {
            this.server.dispatchCommand((CommandSender)player2, "test vibration 1.0 2.0 3.0 4");
        }
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.VIBRATION, (Object)result.particle());
        Assertions.assertEquals((int)4, (int)((Vibration)result.data()).getArrivalTime());
        Assertions.assertInstanceOf(Vibration.Destination.BlockDestination.class, (Object)((Vibration)result.data()).getDestination());
        Vibration.Destination.BlockDestination blockDestination = (Vibration.Destination.BlockDestination)((Vibration)result.data()).getDestination();
        Assertions.assertEquals((int)1, (int)blockDestination.getLocation().getBlockX());
        Assertions.assertEquals((int)2, (int)blockDestination.getLocation().getBlockY());
        Assertions.assertEquals((int)3, (int)blockDestination.getLocation().getBlockZ());
        this.assertNoMoreResults(results);
    }
}

