/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.NamespacedKeyArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class ArgumentNamespacedKeyTests
extends TestBase {
    ArgumentNamespacedKeyTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithNamespacedKeyArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NamespacedKeyArgument("namespace")})).executesPlayer((player, args) -> results.set((NamespacedKey)args.get("namespace")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test key");
        Assertions.assertEquals((Object)new NamespacedKey("minecraft", "key"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test mynamespace:key");
        Assertions.assertEquals((Object)new NamespacedKey("mynamespace", "key"), results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithNamespacedKeyArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NamespacedKeyArgument("namespace")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Disabled
    @Test
    void suggestionTestWithNamespacedKeyArgumentSuggestions() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new NamespacedKeyArgument("namespace").replaceSuggestions(ArgumentSuggestions.stringCollection(info -> {
            String input = info.currentArg();
            List<String> s = Arrays.stream(Material.values()).filter(it -> !it.isLegacy()).map(it -> it.getKey().toString()).filter(it -> it.toString().startsWith(input) || it.toString().contains("_" + input)).toList();
            return s;
        }))})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        List<String> suggestions = Arrays.stream(Material.values()).filter(s -> !s.isLegacy()).map(i -> i.getKey()).filter(k -> k.toString().contains("_log") || k.toString().startsWith("log")).map(s -> s.toString()).sorted().toList();
        Assertions.assertEquals(suggestions, this.server.getSuggestions((CommandSender)player, "test log"));
    }
}

