/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.LootTableArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.Arrays;
import java.util.stream.Stream;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.loot.LootTable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentLootTableTests
extends TestBase {
    ArgumentLootTableTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithLootTableArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LootTableArgument("loottable")})).executesPlayer((player, args) -> results.set((LootTable)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test chests/simple_dungeon");
        Assertions.assertEquals((Object)NamespacedKey.minecraft((String)"chests/simple_dungeon"), (Object)((LootTable)results.get()).getKey());
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithLootTableArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LootTableArgument("loottable")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_19_4)) {
            Stream<String> expected = Stream.concat(Arrays.stream(MockPlatform.getInstance().getLootTables()).map(lt -> lt.getKey().toString()), Stream.of("minecraft:entities/camel", "minecraft:entities/sniffer"));
            Assertions.assertEquals(expected.sorted().toList(), this.server.getSuggestions((CommandSender)player, "test "));
        } else {
            Assertions.assertEquals(Arrays.stream(MockPlatform.getInstance().getLootTables()).map(lt -> lt.getKey().toString()).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test "));
        }
    }
}

