/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.LocationArgument;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentLocationTests
extends TestBase {
    ArgumentLocationTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    private void assertLocationEquals(Location loc1, Location loc2) {
        Assertions.assertEquals((Object)loc1.getWorld(), (Object)loc2.getWorld());
        Assertions.assertEquals((double)loc1.getX(), (double)loc2.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)loc1.getY(), (double)loc2.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)loc1.getZ(), (double)loc2.getZ(), (double)1.0E-4);
    }

    @Test
    void executionTestWithLocationArgumentPrecisePosition() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LocationArgument("location", LocationType.PRECISE_POSITION)})).executesPlayer((player, args) -> results.set((Location)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 1 10 15");
        this.assertLocationEquals(new Location(null, 1.5, 10.0, 15.5), (Location)results.get());
        this.server.dispatchCommand((CommandSender)player2, "test 1.0 10.0 15.0");
        this.assertLocationEquals(new Location(null, 1.0, 10.0, 15.0), (Location)results.get());
        this.server.dispatchCommand((CommandSender)player2, "test 1.2 10.2 15.2");
        this.assertLocationEquals(new Location(null, 1.2, 10.2, 15.2), (Location)results.get());
        player2.setLocation(new Location(player2.getWorld(), 2.0, 2.5, 2.0));
        this.server.dispatchCommand((CommandSender)player2, "test ~ ~5 ~");
        this.assertLocationEquals(new Location(null, 2.0, 7.5, 2.0), (Location)results.get());
        player2.setLocation(new Location(player2.getWorld(), 2.0, 2.0, 2.0, 0.0f, 0.0f));
        this.server.dispatchCommand((CommandSender)player2, "test ^ ^ ^5");
        this.assertLocationEquals(new Location(null, 2.0, 2.0, 7.0), (Location)results.get());
        player2.setLocation(new Location(player2.getWorld(), 2.0, 2.0, 2.0, -180.0f, 0.0f));
        this.server.dispatchCommand((CommandSender)player2, "test ^ ^ ^5");
        this.assertLocationEquals(new Location(null, 2.0, 2.0, -3.0), (Location)results.get());
    }

    @Test
    void executionTestWithLocationArgumentPrecisePositionNoCentering() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LocationArgument("location", LocationType.PRECISE_POSITION, false)})).executesPlayer((player, args) -> results.set((Location)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 1 10 15");
        this.assertLocationEquals(new Location(null, 1.0, 10.0, 15.0), (Location)results.get());
        this.server.dispatchCommand((CommandSender)player2, "test 1.0 10.0 15.0");
        this.assertLocationEquals(new Location(null, 1.0, 10.0, 15.0), (Location)results.get());
        this.server.dispatchCommand((CommandSender)player2, "test 1.2 10.2 15.2");
        this.assertLocationEquals(new Location(null, 1.2, 10.2, 15.2), (Location)results.get());
        player2.setLocation(new Location(player2.getWorld(), 2.0, 2.5, 2.0));
        this.server.dispatchCommand((CommandSender)player2, "test ~ ~5 ~");
        this.assertLocationEquals(new Location(null, 2.0, 7.5, 2.0), (Location)results.get());
    }

    @Test
    void executionTestWithLocationArgumentBlockPosition() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LocationArgument("location", LocationType.BLOCK_POSITION)})).executesPlayer((player, args) -> results.set((Location)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 1 10 15");
        this.assertLocationEquals(new Location(null, 1.0, 10.0, 15.0), (Location)results.get());
        player2.setLocation(new Location(player2.getWorld(), 2.0, 2.5, 2.0));
        this.server.dispatchCommand((CommandSender)player2, "test ~ ~5 ~");
        this.assertLocationEquals(new Location(null, 2.0, 7.0, 2.0), (Location)results.get());
        player2.setLocation(new Location(player2.getWorld(), 2.0, 2.0, 2.0, 0.0f, 0.0f));
        this.server.dispatchCommand((CommandSender)player2, "test ^ ^ ^5");
        this.assertLocationEquals(new Location(null, 2.0, 2.0, 7.0), (Location)results.get());
        player2.setLocation(new Location(player2.getWorld(), 2.0, 2.0, 2.0, -180.0f, 0.0f));
        this.server.dispatchCommand((CommandSender)player2, "test ^ ^ ^5");
        this.assertLocationEquals(new Location(null, 2.0, 2.0, -3.0), (Location)results.get());
    }
}

