/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.exceptions.BadLiteralException;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentLiteralTests
extends TestBase {
    ArgumentLiteralTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithLiteralArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument("literal")})).executesPlayer((player, args) -> {
            Assertions.assertEquals((int)0, (int)args.args().length);
            results.set((String)args.get(0));
        })).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test literal");
        Assertions.assertEquals(null, results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithLiteralArgumentListed() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new LiteralArgument("literal").setListed(true)})).executesPlayer((player, args) -> {
            Assertions.assertEquals((int)1, (int)args.args().length);
            results.set((String)args.get(0));
        })).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test literal");
        Assertions.assertEquals((Object)"literal", results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    public void executionTestWithLiteralArgumentListedAndNodeName() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new LiteralArgument("literal").setListed(true)})).executesPlayer((player, args) -> {
            Assertions.assertEquals((int)1, (int)args.args().length);
            results.set((String)args.get("literal"));
        })).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test literal");
        Assertions.assertEquals((Object)"literal", results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void dispatcherTestWithLiteralArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument("literal")})).executesPlayer(P_EXEC)).register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"literal\": {\n          \"type\": \"literal\",\n          \"executable\": true\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
    }

    @Test
    void exceptionTestWithLiteralArgumentInvalid() {
        Assertions.assertThrows(BadLiteralException.class, () -> new LiteralArgument(null));
        Assertions.assertThrows(BadLiteralException.class, () -> new LiteralArgument(""));
        Assertions.assertDoesNotThrow(() -> new LiteralArgument("\u3053\u3093\u306b\u3061\u306f"));
    }

    @Test
    void suggestionTestWithLiteralArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument("literal")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("literal"), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void suggestionTestWithTwoLiteralArguments() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument("literal1")})).executesPlayer(P_EXEC)).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument("literal2")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("literal1", "literal2"), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

