/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.PlayerArgument;
import dev.jorel.commandapi.exceptions.GreedyArgumentException;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentGreedyStringTests
extends TestBase {
    ArgumentGreedyStringTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithGreedyStringArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("value")})).executesPlayer((player, args) -> results.set((String)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test Hello World");
        Assertions.assertEquals((Object)"Hello World", results.get());
        this.server.dispatchCommand((CommandSender)player2, "test Hello");
        Assertions.assertEquals((Object)"Hello", results.get());
        this.server.dispatchCommand((CommandSender)player2, "test \"\"*`?#+*!\"\u00a7");
        Assertions.assertEquals((Object)"\"\"*`?#+*!\"\u00a7", results.get());
        this.server.dispatchCommand((CommandSender)player2, "test \u3053\u3093\u306b\u3061\u306f");
        Assertions.assertEquals((Object)"\u3053\u3093\u306b\u3061\u306f", results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void exceptionTestWithGreedyStringArgument() {
        Assertions.assertThrows(GreedyArgumentException.class, () -> ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("greedy")})).withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("player")})).executesPlayer(P_EXEC)).register());
    }

    @Test
    void suggestionTestWithGreedyStringArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("value")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

