/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.BlockStateArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.EndPortalFrame;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentBlockStateTests
extends TestBase {
    ArgumentBlockStateTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithBlockStateArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new BlockStateArgument("blockstate")})).executesPlayer((player, args) -> results.set((BlockData)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test dirt");
        Assertions.assertEquals((Object)Material.DIRT, (Object)((BlockData)results.get()).getMaterial());
        this.server.dispatchCommand((CommandSender)player2, "test end_portal_frame[eye=true,facing=north]");
        BlockData endPortalFrameBlockData = (BlockData)results.get();
        Assertions.assertEquals((Object)Material.END_PORTAL_FRAME, (Object)endPortalFrameBlockData.getMaterial());
        Assertions.assertInstanceOf(EndPortalFrame.class, (Object)endPortalFrameBlockData);
        EndPortalFrame frame = (EndPortalFrame)endPortalFrameBlockData;
        Assertions.assertTrue((boolean)frame.hasEye());
        Assertions.assertEquals((Object)BlockFace.NORTH, (Object)frame.getFacing());
        this.server.dispatchCommand((CommandSender)player2, "test chest{CustomName:\"\\\"Custom Name\\\"\"}");
        Assertions.assertEquals((Object)"minecraft:chest[facing=north,type=single,waterlogged=false]", (Object)((BlockData)results.get()).getAsString());
        this.assertNoMoreResults(results);
    }
}

