/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.BiomeArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentBiomeTests
extends TestBase {
    ArgumentBiomeTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithBiomeArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new BiomeArgument("biome")})).executesPlayer((player, args) -> results.set((Biome)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test plains");
        Assertions.assertEquals((Object)Biome.PLAINS, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:plains");
        Assertions.assertEquals((Object)Biome.PLAINS, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test unknownbiome");
        Assertions.assertNull(results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithBiomeArgumentAllBiomes() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new BiomeArgument("biome")})).executesPlayer((player, args) -> results.set((Biome)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (Biome biome : MockPlatform.getInstance().getBiomes()) {
            if (biome == Biome.CUSTOM) continue;
            this.server.dispatchCommand((CommandSender)player2, "test " + String.valueOf(biome.getKey()));
            Assertions.assertEquals((Object)biome, results.get());
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithBiomeArgumentNamespaced() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new BiomeArgument.NamespacedKey("biome")})).executesPlayer((player, args) -> results.set((NamespacedKey)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test plains");
        Assertions.assertEquals((Object)NamespacedKey.minecraft((String)"plains"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:plains");
        Assertions.assertEquals((Object)NamespacedKey.minecraft((String)"plains"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test unknownbiome");
        Assertions.assertEquals((Object)NamespacedKey.minecraft((String)"unknownbiome"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test mynamespace:unknownbiome");
        Assertions.assertEquals((Object)new NamespacedKey("mynamespace", "unknownbiome"), results.get());
        this.assertNoMoreResults(results);
    }
}

