/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.AdventureChatColorArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentAdventureChatColorTests
extends TestBase {
    ArgumentAdventureChatColorTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithChatColorArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AdventureChatColorArgument("color")})).executesPlayer((player, args) -> results.set((NamedTextColor)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (String str : new String[]{"black", "dark_blue", "dark_green", "dark_aqua", "dark_red", "dark_purple", "gold", "gray", "dark_gray", "blue", "green", "aqua", "red", "light_purple", "yellow", "white"}) {
            this.server.dispatchCommand((CommandSender)player2, "test " + str);
            Assertions.assertEquals((Object)NamedTextColor.NAMES.value((Object)str), results.get());
        }
        this.server.dispatchCommand((CommandSender)player2, "test reset");
        Assertions.assertEquals((Object)NamedTextColor.WHITE, results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithChatColorArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AdventureChatColorArgument("color")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("dark_aqua", "dark_blue", "dark_gray", "dark_green", "dark_purple", "dark_red"), this.server.getSuggestions((CommandSender)player, "test d"));
    }
}

