/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CommandUnregisterTests
extends TestBase {
    PlayerMock player;
    Mut<String> vanillaResults;
    CommandMap commandMap;
    Mut<String> bukkitResults;
    Command bukkitCommand;

    CommandUnregisterTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        CommandUnregisterTests.disablePaperImplementations();
        this.player = this.server.addPlayer();
        this.vanillaResults = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withAliases(new String[]{"minecraft:test"})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executes((sender, args) -> this.vanillaResults.set((String)args.getUnchecked(0)), new ExecutorType[0])).register();
        Assertions.assertEquals((Object)BRIG_TREE.FULL, (Object)this.getDispatcherString());
        this.assertStoresResult((CommandSender)this.player, "test word", this.vanillaResults, "word");
        this.assertStoresResult((CommandSender)this.player, "minecraft:test word", this.vanillaResults, "word");
        this.commandMap = CommandAPIBukkit.get().getSimpleCommandMap();
        this.bukkitResults = Mut.of();
        this.bukkitCommand = new Command("test"){

            public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] arguments) {
                if (arguments.length == 0) {
                    return false;
                }
                CommandUnregisterTests.this.bukkitResults.set(arguments[0]);
                return true;
            }
        };
        this.commandMap.register("bukkit", this.bukkitCommand);
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("test"));
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("bukkit:test"));
        this.assertStoresResult((CommandSender)this.player, "test word", this.bukkitResults, "word");
        this.assertStoresResult((CommandSender)this.player, "bukkit:test word", this.bukkitResults, "word");
        this.assertNoMoreResults(this.vanillaResults);
        this.assertNoMoreResults(this.bukkitResults);
        Assertions.assertTrue((boolean)CommandAPI.canRegister());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void testUnregister() {
        CommandAPI.unregister((String)"test");
        Assertions.assertEquals((Object)BRIG_TREE.NO_MAIN, (Object)this.getDispatcherString());
        this.assertStoresResult((CommandSender)this.player, "test word", this.bukkitResults, "word");
        this.assertStoresResult((CommandSender)this.player, "minecraft:test word", this.vanillaResults, "word");
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("test"));
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("bukkit:test"));
        this.assertStoresResult((CommandSender)this.player, "test word", this.bukkitResults, "word");
        this.assertStoresResult((CommandSender)this.player, "bukkit:test word", this.bukkitResults, "word");
        this.assertNoMoreResults(this.vanillaResults);
        this.assertNoMoreResults(this.bukkitResults);
    }

    @Test
    void testUnregisterNamespace() {
        CommandAPI.unregister((String)"minecraft:test");
        Assertions.assertEquals((Object)BRIG_TREE.NO_NAMESPACE, (Object)this.getDispatcherString());
        this.assertStoresResult((CommandSender)this.player, "test word", this.bukkitResults, "word");
        this.assertCommandFailsWith((CommandSender)this.player, "minecraft:test word", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("test"));
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("bukkit:test"));
        this.assertStoresResult((CommandSender)this.player, "test word", this.bukkitResults, "word");
        this.assertStoresResult((CommandSender)this.player, "bukkit:test word", this.bukkitResults, "word");
        this.assertNoMoreResults(this.vanillaResults);
        this.assertNoMoreResults(this.bukkitResults);
    }

    @Test
    void testUnregisterBoth() {
        CommandAPI.unregister((String)"test", (boolean)true);
        Assertions.assertEquals((Object)BRIG_TREE.EMPTY, (Object)this.getDispatcherString());
        this.assertStoresResult((CommandSender)this.player, "test word", this.bukkitResults, "word");
        this.assertCommandFailsWith((CommandSender)this.player, "minecraft:test word", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("test"));
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("bukkit:test"));
        this.assertStoresResult((CommandSender)this.player, "test word", this.bukkitResults, "word");
        this.assertStoresResult((CommandSender)this.player, "bukkit:test word", this.bukkitResults, "word");
        this.assertNoMoreResults(this.vanillaResults);
        this.assertNoMoreResults(this.bukkitResults);
    }

    @Test
    void testUnregisterBukkit() {
        CommandAPIBukkit.unregister((String)"test", (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)BRIG_TREE.FULL, (Object)this.getDispatcherString());
        this.assertStoresResult((CommandSender)this.player, "test word", this.vanillaResults, "word");
        this.assertStoresResult((CommandSender)this.player, "minecraft:test word", this.vanillaResults, "word");
        Assertions.assertNull((Object)this.commandMap.getCommand("test"));
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("bukkit:test"));
        this.assertStoresResult((CommandSender)this.player, "test word", this.vanillaResults, "word");
        this.assertStoresResult((CommandSender)this.player, "bukkit:test word", this.bukkitResults, "word");
        this.assertNoMoreResults(this.vanillaResults);
        this.assertNoMoreResults(this.bukkitResults);
    }

    @Test
    void testUnregisterBukkitNamespace() {
        CommandAPIBukkit.unregister((String)"bukkit:test", (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)BRIG_TREE.FULL, (Object)this.getDispatcherString());
        this.assertStoresResult((CommandSender)this.player, "test word", this.bukkitResults, "word");
        this.assertStoresResult((CommandSender)this.player, "minecraft:test word", this.vanillaResults, "word");
        Assertions.assertEquals((Object)this.bukkitCommand, (Object)this.commandMap.getCommand("test"));
        Assertions.assertNull((Object)this.commandMap.getCommand("bukkit:test"));
        this.assertStoresResult((CommandSender)this.player, "test word", this.bukkitResults, "word");
        this.assertCommandFailsWith((CommandSender)this.player, "bukkit:test word", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertNoMoreResults(this.vanillaResults);
        this.assertNoMoreResults(this.bukkitResults);
    }

    @Test
    void testUnregisterBukkitBoth() {
        CommandAPIBukkit.unregister((String)"test", (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)BRIG_TREE.FULL, (Object)this.getDispatcherString());
        this.assertStoresResult((CommandSender)this.player, "test word", this.vanillaResults, "word");
        this.assertStoresResult((CommandSender)this.player, "minecraft:test word", this.vanillaResults, "word");
        Assertions.assertNull((Object)this.commandMap.getCommand("test"));
        Assertions.assertNull((Object)this.commandMap.getCommand("bukkit:test"));
        this.assertStoresResult((CommandSender)this.player, "test word", this.vanillaResults, "word");
        this.assertCommandFailsWith((CommandSender)this.player, "bukkit:test word", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertNoMoreResults(this.vanillaResults);
        this.assertNoMoreResults(this.bukkitResults);
    }

    @Test
    void testUnregisterWithHangingColons() {
        this.commandMap.registerAll("plugin", List.of(new Command(":command"){

            public boolean execute(@NotNull CommandSender commandSender, @NotNull String s, @NotNull String[] strings) {
                return true;
            }
        }, new Command("namespace:"){

            public boolean execute(@NotNull CommandSender commandSender, @NotNull String s, @NotNull String[] strings) {
                return true;
            }
        }));
        this.testUnregisterBukkitBoth();
    }

    static class BRIG_TREE {
        static String FULL = "{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"string\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    },\n    \"minecraft:test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"string\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    }\n  }\n}";
        static String NO_MAIN = "{\n  \"type\": \"root\",\n  \"children\": {\n    \"minecraft:test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"string\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    }\n  }\n}";
        static String NO_NAMESPACE = "{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"string\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    }\n  }\n}";
        static String EMPTY = "{\n  \"type\": \"root\"\n}";

        BRIG_TREE() {
        }
    }
}

