/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import dev.jorel.commandapi.AbstractArgumentTree;
import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandTree;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.exceptions.GreedyArgumentException;
import dev.jorel.commandapi.exceptions.InvalidCommandNameException;
import dev.jorel.commandapi.exceptions.MissingCommandExecutorException;
import dev.jorel.commandapi.test.TestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class CommandRegistrationTests
extends TestBase {
    CommandRegistrationTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void testCommandAPICommandGreedyArgumentException() {
        CommandAPICommand validGreedyCommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")})).withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("arg2")})).executesPlayer(P_EXEC);
        Assertions.assertDoesNotThrow(() -> validGreedyCommand.register());
        CommandAPICommand invalidGreedyCommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("arg1")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg2")})).executesPlayer(P_EXEC);
        this.assertThrowsWithMessage(GreedyArgumentException.class, "Only one GreedyStringArgument or ChatArgument can be declared, at the end of a List. Found arguments: arg1<GreedyStringArgument> arg2<StringArgument> ", () -> ((CommandAPICommand)invalidGreedyCommand).register());
    }

    @Test
    void testCommandTreeGreedyArgumentException() {
        CommandTree validGreedyCommand = (CommandTree)new CommandTree("test").then(new StringArgument("arg1").then((AbstractArgumentTree)new GreedyStringArgument("arg2").executesPlayer(P_EXEC)));
        Assertions.assertDoesNotThrow(() -> validGreedyCommand.register());
        CommandTree invalidGreedyCommand = (CommandTree)new CommandTree("test").then(new GreedyStringArgument("arg1").then((AbstractArgumentTree)new StringArgument("arg2").executesPlayer(P_EXEC)));
        this.assertThrowsWithMessage(GreedyArgumentException.class, "Only one GreedyStringArgument or ChatArgument can be declared, at the end of a List. Found arguments: arg1<GreedyStringArgument> arg2<StringArgument> ", () -> ((CommandTree)invalidGreedyCommand).register());
    }

    @Test
    void testCommandAPICommandInvalidCommandNameException() {
        this.assertThrowsWithMessage(InvalidCommandNameException.class, "Invalid command with name 'null' cannot be registered!", () -> new CommandAPICommand((String)null));
        this.assertThrowsWithMessage(InvalidCommandNameException.class, "Invalid command with name '' cannot be registered!", () -> new CommandAPICommand(""));
        this.assertThrowsWithMessage(InvalidCommandNameException.class, "Invalid command with name 'my command' cannot be registered!", () -> new CommandAPICommand("my command"));
    }

    @Test
    void testCommandTreeInvalidCommandNameException() {
        this.assertThrowsWithMessage(InvalidCommandNameException.class, "Invalid command with name 'null' cannot be registered!", () -> new CommandTree(null));
        this.assertThrowsWithMessage(InvalidCommandNameException.class, "Invalid command with name '' cannot be registered!", () -> new CommandTree(""));
        this.assertThrowsWithMessage(InvalidCommandNameException.class, "Invalid command with name 'my command' cannot be registered!", () -> new CommandTree("my command"));
    }

    @Test
    void testCommandAPICommandMissingCommandExecutorException() {
        CommandAPICommand commandWithNoExecutors = (CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")});
        this.assertThrowsWithMessage(MissingCommandExecutorException.class, "/test does not declare any executors or executable subcommands!", () -> ((CommandAPICommand)commandWithNoExecutors).register());
        CommandAPICommand commandWithNoRunnableSubcommands = (CommandAPICommand)new CommandAPICommand("test").withSubcommand((AbstractCommandAPICommand)new CommandAPICommand("sub"));
        this.assertThrowsWithMessage(MissingCommandExecutorException.class, "/test does not declare any executors or executable subcommands!", () -> ((CommandAPICommand)commandWithNoRunnableSubcommands).register());
        CommandAPICommand commandWithEventuallyRunnableSubcommand = (CommandAPICommand)new CommandAPICommand("test").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)new CommandAPICommand("sub").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)new CommandAPICommand("sub").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)new CommandAPICommand("sub").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)new CommandAPICommand("sub").executesPlayer(P_EXEC)))))))));
        Assertions.assertDoesNotThrow(() -> commandWithEventuallyRunnableSubcommand.register());
    }

    @Disabled
    @Test
    void testCommandTreeMissingCommandExecutorException() {
        CommandTree commandWithNoExecutors = new CommandTree("test");
        this.assertThrowsWithMessage(MissingCommandExecutorException.class, "", () -> ((CommandTree)commandWithNoExecutors).register());
        CommandTree commandWithNoRunnableSubcommands = (CommandTree)new CommandTree("test").then((AbstractArgumentTree)new LiteralArgument("sub"));
        this.assertThrowsWithMessage(MissingCommandExecutorException.class, "", () -> ((CommandTree)commandWithNoRunnableSubcommands).register());
        CommandTree commandWithEventuallyRunnableSubcommand = (CommandTree)new CommandTree("test").then(new LiteralArgument("sub").then(new LiteralArgument("sub").then(new LiteralArgument("sub").then((AbstractArgumentTree)new LiteralArgument("sub").executesPlayer(P_EXEC)))));
        Assertions.assertDoesNotThrow(() -> commandWithEventuallyRunnableSubcommand.register());
        CommandTree commandTreeWithSomeNotExecutablePaths = (CommandTree)((CommandTree)((CommandTree)((CommandTree)new CommandTree("test").then(new LiteralArgument("executable1").then((AbstractArgumentTree)new LiteralArgument("sub").executesPlayer(P_EXEC)))).then(new LiteralArgument("notExecutable1").then((AbstractArgumentTree)new LiteralArgument("sub")))).then(new LiteralArgument("notExecutable2").then((AbstractArgumentTree)new LiteralArgument("sub")))).then(new LiteralArgument("executable2").then((AbstractArgumentTree)new LiteralArgument("sub").executesPlayer(P_EXEC)));
        this.assertThrowsWithMessage(MissingCommandExecutorException.class, "", () -> ((CommandTree)commandTreeWithSomeNotExecutablePaths).register());
    }

    @Test
    void testCommandAPICommandDuplicateNodeNameException() {
        CommandAPIHandler.getInstance().writeDispatcherToFile();
        CommandAPICommand commandWithDuplicateArgumentNames = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("alice"), new StringArgument("bob"), new StringArgument("alice")})).executesPlayer(P_EXEC);
        commandWithDuplicateArgumentNames.register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\"\n}", (Object)this.getDispatcherString());
        CommandAPICommand commandWithDuplicateLiteralArgumentNames = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument("alice"), new LiteralArgument("bob"), new LiteralArgument("alice")})).executesPlayer(P_EXEC);
        commandWithDuplicateLiteralArgumentNames.register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"alice\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"bob\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"alice\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
        CommandAPICommand commandWithDuplicateMultiLiteralArgumentNames = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument("alice", new String[]{"option1", "option2"}), new MultiLiteralArgument("bob", new String[]{"option1", "option2"}), new MultiLiteralArgument("alice", new String[]{"option1", "option2"})})).executesPlayer(P_EXEC);
        commandWithDuplicateMultiLiteralArgumentNames.register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"alice\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"bob\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"alice\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        },\n        \"option1\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        },\n        \"option2\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
    }

    @Test
    void testCommandTreeDuplicateNodeNameException() {
        CommandAPIHandler.getInstance().writeDispatcherToFile();
        CommandTree commandWithDuplicateArgumentNames = (CommandTree)new CommandTree("test").then(new StringArgument("alice").then(new StringArgument("bob").then((AbstractArgumentTree)new StringArgument("alice").executesPlayer(P_EXEC))));
        commandWithDuplicateArgumentNames.register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\"\n}", (Object)this.getDispatcherString());
        CommandTree commandWithDuplicateLiteralArgumentNames = (CommandTree)new CommandTree("test").then(new LiteralArgument("alice").then(new LiteralArgument("bob").then((AbstractArgumentTree)new LiteralArgument("alice").executesPlayer(P_EXEC))));
        commandWithDuplicateLiteralArgumentNames.register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"alice\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"bob\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"alice\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
        CommandTree commandWithDuplicateMultiLiteralArgumentNames = (CommandTree)new CommandTree("test").then(new MultiLiteralArgument("alice", new String[]{"option1", "option2"}).then(new MultiLiteralArgument("bob", new String[]{"option1", "option2"}).then((AbstractArgumentTree)new MultiLiteralArgument("alice", new String[]{"option1", "option2"}).executesPlayer(P_EXEC))));
        commandWithDuplicateMultiLiteralArgumentNames.register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"alice\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"bob\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"alice\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        },\n        \"option1\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        },\n        \"option2\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
        CommandTree commandWithDuplicateNamesSeparated = (CommandTree)((CommandTree)((CommandTree)((CommandTree)new CommandTree("test").then(new LiteralArgument("path1").then((AbstractArgumentTree)new StringArgument("alice").executesPlayer(P_EXEC)))).then(new LiteralArgument("path2").then((AbstractArgumentTree)new StringArgument("alice").executesPlayer(P_EXEC)))).then(new LiteralArgument("path3").then((AbstractArgumentTree)new StringArgument("alice").executesPlayer(P_EXEC)))).then(new LiteralArgument("path4").then((AbstractArgumentTree)new StringArgument("alice").executesPlayer(P_EXEC)));
        commandWithDuplicateNamesSeparated.register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"test\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"alice\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"bob\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"alice\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        },\n        \"option1\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        },\n        \"option2\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        },\n        \"path1\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"alice\": {\n              \"type\": \"argument\",\n              \"parser\": \"brigadier:string\",\n              \"properties\": {\n                \"type\": \"word\"\n              },\n              \"executable\": true\n            }\n          }\n        },\n        \"path2\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"alice\": {\n              \"type\": \"argument\",\n              \"parser\": \"brigadier:string\",\n              \"properties\": {\n                \"type\": \"word\"\n              },\n              \"executable\": true\n            }\n          }\n        },\n        \"path3\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"alice\": {\n              \"type\": \"argument\",\n              \"parser\": \"brigadier:string\",\n              \"properties\": {\n                \"type\": \"word\"\n              },\n              \"executable\": true\n            }\n          }\n        },\n        \"path4\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"alice\": {\n              \"type\": \"argument\",\n              \"parser\": \"brigadier:string\",\n              \"properties\": {\n                \"type\": \"word\"\n              },\n              \"executable\": true\n            }\n          }\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
    }
}

