/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dev.jorel.commandapi.AbstractArgumentTree;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkitConfig;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandTree;
import dev.jorel.commandapi.InternalBukkitConfig;
import dev.jorel.commandapi.SpigotCommandRegistration;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CommandNamespaceTests
extends TestBase {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    Player enableWithNamespaces() {
        MockPlatform mockPlatform = MockPlatform.getInstance();
        SimpleCommandMap commandMap = mockPlatform.getSimpleCommandMap();
        SpigotCommandRegistration spigotCommandRegistration = (SpigotCommandRegistration)mockPlatform.getCommandRegistrationStrategy();
        for (CommandNode node : mockPlatform.getBrigadierDispatcher().getRoot().getChildren()) {
            commandMap.register("minecraft", spigotCommandRegistration.wrapToVanillaCommandWrapper(node));
        }
        this.enableServer();
        Player runCommandsPlayer = this.server.setupMockedCraftPlayer();
        PermissibleBase perm = new PermissibleBase((ServerOperator)runCommandsPlayer);
        Mockito.when((Object)runCommandsPlayer.addAttachment((Plugin)ArgumentMatchers.isA(Plugin.class))).thenAnswer(invocation -> perm.addAttachment((Plugin)invocation.getArgument(0)));
        Mockito.when((Object)runCommandsPlayer.addAttachment((Plugin)ArgumentMatchers.isA(Plugin.class), (String)ArgumentMatchers.isA(String.class), ((Boolean)ArgumentMatchers.isA(Boolean.class)).booleanValue())).thenAnswer(invocation -> perm.addAttachment((Plugin)invocation.getArgument(0), (String)invocation.getArgument(1), ((Boolean)invocation.getArgument(2)).booleanValue()));
        ((Player)Mockito.doAnswer(invocation -> {
            perm.recalculatePermissions();
            return null;
        }).when((Object)runCommandsPlayer)).recalculatePermissions();
        Mockito.when((Object)runCommandsPlayer.hasPermission((String)ArgumentMatchers.isA(String.class))).thenAnswer(invocation -> perm.hasPermission((String)invocation.getArgument(0, String.class)));
        return runCommandsPlayer;
    }

    @Test
    public void testNullNamespaceWithCommandAPICommand() {
        CommandAPICommand command = (CommandAPICommand)new CommandAPICommand("test").executesPlayer(P_EXEC);
        this.assertThrowsWithMessage(NullPointerException.class, "Parameter 'namespace' was null when registering command /test!", () -> command.register((String)null));
    }

    @Test
    public void testNullNamespaceWithCommandTree() {
        CommandTree commandTree = (CommandTree)new CommandTree("test").executesPlayer(P_EXEC);
        this.assertThrowsWithMessage(NullPointerException.class, "Parameter 'namespace' was null when registering command /test!", () -> commandTree.register((String)null));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testDefaultMinecraftNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer(info -> results.set((String)info.args().getUnchecked("string")));
        command.register();
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        RootCommandNode rootNode = MockPlatform.getInstance().getBrigadierDispatcher().getRoot();
        Assertions.assertNotNull((Object)rootNode.getChild("test"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        SimpleCommandMap commandMap = MockPlatform.getInstance().getSimpleCommandMap();
        Assertions.assertNotNull((Object)commandMap.getCommand("test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("minecraft:test"));
        this.assertStoresResult((CommandSender)player, "test alpha", results, "alpha");
        this.assertStoresResult((CommandSender)player, "minecraft:test alpha", results, "alpha");
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testStringNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer(info -> results.set((String)info.args().getUnchecked("string")));
        command.register("commandtest");
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        RootCommandNode rootNode = MockPlatform.getInstance().getBrigadierDispatcher().getRoot();
        Assertions.assertNotNull((Object)rootNode.getChild("test"));
        Assertions.assertNotNull((Object)rootNode.getChild("commandtest:test"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        SimpleCommandMap commandMap = MockPlatform.getInstance().getSimpleCommandMap();
        Assertions.assertNotNull((Object)commandMap.getCommand("test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("commandtest:test"));
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:test"));
        this.assertStoresResult((CommandSender)player, "test alpha", results, "alpha");
        this.assertStoresResult((CommandSender)player, "commandtest:test alpha", results, "alpha");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:test alpha", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testPluginNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer(info -> results.set((String)info.args().getUnchecked("string")));
        command.register(MockPlatform.getConfiguration().getPlugin());
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        RootCommandNode rootNode = MockPlatform.getInstance().getBrigadierDispatcher().getRoot();
        Assertions.assertNotNull((Object)rootNode.getChild("test"));
        Assertions.assertNotNull((Object)rootNode.getChild("commandapitest:test"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        SimpleCommandMap commandMap = MockPlatform.getInstance().getSimpleCommandMap();
        Assertions.assertNotNull((Object)commandMap.getCommand("test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("commandapitest:test"));
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:test"));
        this.assertStoresResult((CommandSender)player, "test alpha", results, "alpha");
        this.assertStoresResult((CommandSender)player, "commandapitest:test alpha", results, "alpha");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:test alpha", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testAliasesWithDefaultNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withAliases(new String[]{"alpha", "beta"})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer(info -> results.set((String)info.args().getUnchecked("string")));
        command.register();
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        RootCommandNode rootNode = MockPlatform.getInstance().getBrigadierDispatcher().getRoot();
        Assertions.assertNotNull((Object)rootNode.getChild("test"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        Assertions.assertNotNull((Object)rootNode.getChild("alpha"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:alpha"));
        Assertions.assertNotNull((Object)rootNode.getChild("beta"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:beta"));
        SimpleCommandMap commandMap = MockPlatform.getInstance().getSimpleCommandMap();
        Assertions.assertNotNull((Object)commandMap.getCommand("test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("minecraft:test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("alpha"));
        Assertions.assertNotNull((Object)commandMap.getCommand("minecraft:alpha"));
        Assertions.assertNotNull((Object)commandMap.getCommand("beta"));
        Assertions.assertNotNull((Object)commandMap.getCommand("minecraft:beta"));
        this.assertStoresResult((CommandSender)player, "test discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "alpha discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "beta discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "minecraft:test discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "minecraft:alpha discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "minecraft:beta discord", results, "discord");
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testAliasesWithCustomNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withAliases(new String[]{"alpha", "beta"})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer(info -> results.set((String)info.args().getUnchecked("string")));
        command.register("commandtest");
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        RootCommandNode rootNode = MockPlatform.getInstance().getBrigadierDispatcher().getRoot();
        Assertions.assertNotNull((Object)rootNode.getChild("test"));
        Assertions.assertNotNull((Object)rootNode.getChild("commandtest:test"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        Assertions.assertNotNull((Object)rootNode.getChild("alpha"));
        Assertions.assertNotNull((Object)rootNode.getChild("commandtest:alpha"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        Assertions.assertNotNull((Object)rootNode.getChild("beta"));
        Assertions.assertNotNull((Object)rootNode.getChild("commandtest:beta"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        SimpleCommandMap commandMap = MockPlatform.getInstance().getSimpleCommandMap();
        Assertions.assertNotNull((Object)commandMap.getCommand("test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("commandtest:test"));
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("alpha"));
        Assertions.assertNotNull((Object)commandMap.getCommand("commandtest:alpha"));
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:alpha"));
        Assertions.assertNotNull((Object)commandMap.getCommand("beta"));
        Assertions.assertNotNull((Object)commandMap.getCommand("commandtest:beta"));
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:beta"));
        this.assertStoresResult((CommandSender)player, "test discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "alpha discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "beta discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "commandtest:test discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "commandtest:alpha discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "commandtest:beta discord", results, "discord");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:test discord", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:alpha discord", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:beta discord", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testAliasesWithPluginNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withAliases(new String[]{"alpha", "beta"})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer(info -> results.set((String)info.args().getUnchecked("string")));
        command.register(MockPlatform.getConfiguration().getPlugin());
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        RootCommandNode rootNode = MockPlatform.getInstance().getBrigadierDispatcher().getRoot();
        Assertions.assertNotNull((Object)rootNode.getChild("test"));
        Assertions.assertNotNull((Object)rootNode.getChild("commandapitest:test"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        Assertions.assertNotNull((Object)rootNode.getChild("alpha"));
        Assertions.assertNotNull((Object)rootNode.getChild("commandapitest:alpha"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        Assertions.assertNotNull((Object)rootNode.getChild("beta"));
        Assertions.assertNotNull((Object)rootNode.getChild("commandapitest:beta"));
        Assertions.assertNull((Object)rootNode.getChild("minecraft:test"));
        SimpleCommandMap commandMap = MockPlatform.getInstance().getSimpleCommandMap();
        Assertions.assertNotNull((Object)commandMap.getCommand("test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("commandapitest:test"));
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("alpha"));
        Assertions.assertNotNull((Object)commandMap.getCommand("commandapitest:alpha"));
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("beta"));
        Assertions.assertNotNull((Object)commandMap.getCommand("commandapitest:beta"));
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:test"));
        this.assertStoresResult((CommandSender)player, "test discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "alpha discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "beta discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "commandapitest:test discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "commandapitest:alpha discord", results, "discord");
        this.assertStoresResult((CommandSender)player, "commandapitest:beta discord", results, "discord");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:test discord", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:alpha discord", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:beta discord", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testCommandNameConflictButDifferentNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player tempPlayer = null;
        if (enableBeforeRegistering) {
            tempPlayer = this.enableWithNamespaces();
        }
        CommandAPICommand a = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{LiteralArgument.of((String)"a")})).executesPlayer(info -> results.set("a"));
        CommandAPICommand b = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{LiteralArgument.of((String)"b")})).executesPlayer(info -> results.set("b"));
        a.register("a");
        b.register("b");
        if (!enableBeforeRegistering) {
            tempPlayer = this.enableWithNamespaces();
        }
        Player player = tempPlayer;
        this.assertStoresResult((CommandSender)player, "test a", results, "a");
        this.assertStoresResult((CommandSender)player, "test b", results, "b");
        this.assertStoresResult((CommandSender)player, "a:test a", results, "a");
        this.assertThrowsWithMessage(CommandSyntaxException.class, "Incorrect argument for command at position 7: a:test <--[HERE]", () -> this.server.dispatchThrowableBrigadierCommand((CommandSender)player, "a:test b"));
        this.assertThrowsWithMessage(CommandSyntaxException.class, "Incorrect argument for command at position 7: b:test <--[HERE]", () -> this.server.dispatchThrowableBrigadierCommand((CommandSender)player, "b:test a"));
        this.assertStoresResult((CommandSender)player, "b:test b", results, "b");
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testSameCommandNameConflictWithDefaultNamespaceAndCustomNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player tempPlayer = null;
        if (enableBeforeRegistering) {
            tempPlayer = this.enableWithNamespaces();
        }
        CommandAPICommand defaultNamespace = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{LiteralArgument.of((String)"a")})).executesPlayer(info -> results.set("a"));
        CommandAPICommand customNamespace = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{LiteralArgument.of((String)"b")})).executesPlayer(info -> results.set("b"));
        defaultNamespace.register();
        customNamespace.register("custom");
        if (!enableBeforeRegistering) {
            tempPlayer = this.enableWithNamespaces();
        }
        Player player = tempPlayer;
        RootCommandNode root = MockPlatform.getInstance().getBrigadierDispatcher().getRoot();
        Assertions.assertNotNull((Object)root.getChild("test"));
        Assertions.assertNotNull((Object)root.getChild("custom:test"));
        Assertions.assertNotNull((Object)root.getChild("minecraft:test"));
        SimpleCommandMap commandMap = MockPlatform.getInstance().getSimpleCommandMap();
        Assertions.assertNotNull((Object)commandMap.getCommand("test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("minecraft:test"));
        Assertions.assertNotNull((Object)commandMap.getCommand("custom:test"));
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:custom:test"));
        this.assertStoresResult((CommandSender)player, "test a", results, "a");
        this.assertStoresResult((CommandSender)player, "test b", results, "b");
        this.assertStoresResult((CommandSender)player, "minecraft:test a", results, "a");
        this.assertStoresResult((CommandSender)player, "custom:test b", results, "b");
        this.assertThrowsWithMessage(CommandSyntaxException.class, "Incorrect argument for command at position 12: ...stom:test <--[HERE]", () -> this.server.dispatchThrowableBrigadierCommand((CommandSender)player, "custom:test a"));
        this.assertThrowsWithMessage(CommandSyntaxException.class, "Incorrect argument for command at position 15: ...raft:test <--[HERE]", () -> this.server.dispatchThrowableBrigadierCommand((CommandSender)player, "minecraft:test b"));
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCommandTreeRegistrationDefaultNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandTree command = (CommandTree)((CommandTree)new CommandTree("test").then(new LiteralArgument("a").then((AbstractArgumentTree)new StringArgument("string").executesPlayer(info -> {
            results.set("a");
            results.set((String)info.args().getUnchecked("string"));
        })))).then(new LiteralArgument("b").then((AbstractArgumentTree)new IntegerArgument("integer").executesPlayer(info -> {
            results.set("b");
            results.set(String.valueOf(info.args().get("integer")));
        })));
        command.register();
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        this.server.dispatchCommand((CommandSender)player, "test a alpha");
        Assertions.assertEquals((Object)"a", results.get());
        Assertions.assertEquals((Object)"alpha", results.get());
        this.server.dispatchCommand((CommandSender)player, "minecraft:test a alpha");
        Assertions.assertEquals((Object)"a", results.get());
        Assertions.assertEquals((Object)"alpha", results.get());
        this.server.dispatchCommand((CommandSender)player, "test b 123");
        Assertions.assertEquals((Object)"b", results.get());
        Assertions.assertEquals((Object)"123", results.get());
        this.server.dispatchCommand((CommandSender)player, "minecraft:test b 123");
        Assertions.assertEquals((Object)"b", results.get());
        Assertions.assertEquals((Object)"123", results.get());
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testCommandTreeRegistrationCustomNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandTree command = (CommandTree)((CommandTree)new CommandTree("test").then(new LiteralArgument("a").then((AbstractArgumentTree)new StringArgument("string").executesPlayer(info -> {
            results.set("a");
            results.set((String)info.args().getUnchecked("string"));
        })))).then(new LiteralArgument("b").then((AbstractArgumentTree)new IntegerArgument("integer").executesPlayer(info -> {
            results.set("b");
            results.set(String.valueOf(info.args().get("integer")));
        })));
        command.register("namespace");
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        this.server.dispatchCommand((CommandSender)player, "test a alpha");
        Assertions.assertEquals((Object)"a", results.get());
        Assertions.assertEquals((Object)"alpha", results.get());
        this.server.dispatchCommand((CommandSender)player, "namespace:test a alpha");
        Assertions.assertEquals((Object)"a", results.get());
        Assertions.assertEquals((Object)"alpha", results.get());
        this.server.dispatchCommand((CommandSender)player, "test b 123");
        Assertions.assertEquals((Object)"b", results.get());
        Assertions.assertEquals((Object)"123", results.get());
        this.server.dispatchCommand((CommandSender)player, "namespace:test b 123");
        Assertions.assertEquals((Object)"b", results.get());
        Assertions.assertEquals((Object)"123", results.get());
        this.assertCommandFailsWith((CommandSender)player, "minecraft:test a alpha", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:test b 123", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testCommandTreeRegistrationPluginNamespace(boolean enableBeforeRegistering) {
        Mut results = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandTree command = (CommandTree)((CommandTree)new CommandTree("test").then(new LiteralArgument("a").then((AbstractArgumentTree)new StringArgument("string").executesPlayer(info -> {
            results.set("a");
            results.set((String)info.args().getUnchecked("string"));
        })))).then(new LiteralArgument("b").then((AbstractArgumentTree)new IntegerArgument("integer").executesPlayer(info -> {
            results.set("b");
            results.set(String.valueOf(info.args().get("integer")));
        })));
        command.register(MockPlatform.getConfiguration().getPlugin());
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        this.server.dispatchCommand((CommandSender)player, "test a alpha");
        Assertions.assertEquals((Object)"a", results.get());
        Assertions.assertEquals((Object)"alpha", results.get());
        this.server.dispatchCommand((CommandSender)player, "commandapitest:test a alpha");
        Assertions.assertEquals((Object)"a", results.get());
        Assertions.assertEquals((Object)"alpha", results.get());
        this.server.dispatchCommand((CommandSender)player, "test b 123");
        Assertions.assertEquals((Object)"b", results.get());
        Assertions.assertEquals((Object)"123", results.get());
        this.server.dispatchCommand((CommandSender)player, "commandapitest:test b 123");
        Assertions.assertEquals((Object)"b", results.get());
        Assertions.assertEquals((Object)"123", results.get());
        this.assertCommandFailsWith((CommandSender)player, "minecraft:test a alpha", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "minecraft:test b 123", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    void assertPermissionCheckFails(CommandSender sender, String commandLine) {
        this.assertThrowsWithMessage(CommandSyntaxException.class, "Unknown or incomplete command, see below for error at position 0: <--[HERE]", () -> this.server.dispatchThrowableBrigadierCommand(sender, commandLine));
        Mockito.clearInvocations((Object[])new CommandSender[]{sender});
        this.server.dispatchCommand(sender, commandLine);
        ((CommandSender)Mockito.verify((Object)sender)).sendMessage(String.valueOf(ChatColor.RED) + "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is a mistake.");
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testPermissionsWithDefaultNamespace(boolean enableBeforeRegistering) {
        Mut commandRan = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withPermission("permission")).executesPlayer(info -> commandRan.set("ran"));
        command.register();
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        this.assertPermissionCheckFails((CommandSender)player, "test");
        this.assertPermissionCheckFails((CommandSender)player, "minecraft:test");
        player.addAttachment((Plugin)this.plugin, "permission", true);
        this.assertStoresResult((CommandSender)player, "test", commandRan, "ran");
        this.assertStoresResult((CommandSender)player, "minecraft:test", commandRan, "ran");
        this.assertNoMoreResults(commandRan);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testPermissionsWithCustomNamespace(boolean enableBeforeRegistering) {
        Mut commandRan = Mut.of();
        Player player = null;
        if (enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withPermission("permission")).executesPlayer(info -> commandRan.set("ran"));
        command.register("custom");
        if (!enableBeforeRegistering) {
            player = this.enableWithNamespaces();
        }
        this.assertPermissionCheckFails((CommandSender)player, "test");
        this.assertPermissionCheckFails((CommandSender)player, "custom:test");
        player.addAttachment((Plugin)this.plugin, "permission", true);
        this.assertStoresResult((CommandSender)player, "test", commandRan, "ran");
        this.assertStoresResult((CommandSender)player, "custom:test", commandRan, "ran");
        this.assertNoMoreResults(commandRan);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testPermissionsWithCommandNameConflictButDifferentNamespace(boolean enableBeforeRegistering) {
        Mut commandRan = Mut.of();
        Player tempPlayer = null;
        if (enableBeforeRegistering) {
            tempPlayer = this.enableWithNamespaces();
        }
        CommandAPICommand first = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new LiteralArgument("first").withPermission("first")})).withPermission("first")).executesPlayer(info -> commandRan.set("first"));
        CommandAPICommand second = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new LiteralArgument("second").withPermission("second")})).withPermission("second")).executesPlayer(info -> commandRan.set("second"));
        first.register("first");
        second.register("second");
        if (!enableBeforeRegistering) {
            tempPlayer = this.enableWithNamespaces();
        }
        Player player = tempPlayer;
        PermissionAttachment permissions = player.addAttachment((Plugin)this.plugin);
        permissions.setPermission("first", false);
        permissions.setPermission("second", false);
        player.recalculatePermissions();
        this.assertPermissionCheckFails((CommandSender)player, "test first");
        this.assertPermissionCheckFails((CommandSender)player, "test second");
        this.assertPermissionCheckFails((CommandSender)player, "first:test first");
        this.assertPermissionCheckFails((CommandSender)player, "second:test second");
        permissions.setPermission("first", true);
        permissions.setPermission("second", false);
        player.recalculatePermissions();
        this.assertStoresResult((CommandSender)player, "test first", commandRan, "first");
        this.assertThrowsWithMessage(CommandSyntaxException.class, "Incorrect argument for command at position 5: test <--[HERE]", () -> this.server.dispatchThrowableBrigadierCommand((CommandSender)player, "test second"));
        this.assertStoresResult((CommandSender)player, "first:test first", commandRan, "first");
        this.assertPermissionCheckFails((CommandSender)player, "second:test second");
        permissions.setPermission("first", false);
        permissions.setPermission("second", true);
        player.recalculatePermissions();
        this.assertPermissionCheckFails((CommandSender)player, "test first");
        this.assertPermissionCheckFails((CommandSender)player, "test second");
        this.assertPermissionCheckFails((CommandSender)player, "first:test first");
        this.assertStoresResult((CommandSender)player, "second:test second", commandRan, "second");
        permissions.setPermission("first", true);
        permissions.setPermission("second", true);
        player.recalculatePermissions();
        this.assertStoresResult((CommandSender)player, "test first", commandRan, "first");
        this.assertStoresResult((CommandSender)player, "test second", commandRan, "second");
        this.assertStoresResult((CommandSender)player, "first:test first", commandRan, "first");
        this.assertStoresResult((CommandSender)player, "second:test second", commandRan, "second");
        this.assertNoMoreResults(commandRan);
    }

    @Test
    public void testConfigNamespace() {
        CommandAPIBukkitConfig config = new CommandAPIBukkitConfig(MockPlatform.getConfiguration().getPlugin());
        InternalBukkitConfig internalConfig = new InternalBukkitConfig(config);
        Assertions.assertEquals((Object)"minecraft", (Object)internalConfig.getNamespace());
        CommandAPIBukkitConfig finalConfig = config = new CommandAPIBukkitConfig(MockPlatform.getConfiguration().getPlugin());
        Assertions.assertThrows(NullPointerException.class, () -> finalConfig.setNamespace(null));
        config = new CommandAPIBukkitConfig(MockPlatform.getConfiguration().getPlugin()).setNamespace("");
        internalConfig = new InternalBukkitConfig(config);
        Assertions.assertEquals((Object)"minecraft", (Object)internalConfig.getNamespace());
        config = new CommandAPIBukkitConfig(MockPlatform.getConfiguration().getPlugin()).setNamespace("custom");
        internalConfig = new InternalBukkitConfig(config);
        Assertions.assertEquals((Object)"custom", (Object)internalConfig.getNamespace());
        config = new CommandAPIBukkitConfig(MockPlatform.getConfiguration().getPlugin()).usePluginNamespace();
        internalConfig = new InternalBukkitConfig(config);
        Assertions.assertEquals((Object)"commandapitest", (Object)internalConfig.getNamespace());
        config = new CommandAPIBukkitConfig(MockPlatform.getConfiguration().getPlugin()).setNamespace("custom").usePluginNamespace();
        internalConfig = new InternalBukkitConfig(config);
        Assertions.assertEquals((Object)"commandapitest", (Object)internalConfig.getNamespace());
        config = new CommandAPIBukkitConfig(MockPlatform.getConfiguration().getPlugin()).setNamespace("custom").usePluginNamespace().setNamespace("custom");
        internalConfig = new InternalBukkitConfig(config);
        Assertions.assertEquals((Object)"commandapitest", (Object)internalConfig.getNamespace());
        config = new CommandAPIBukkitConfig(MockPlatform.getConfiguration().getPlugin()).setNamespace("Custom");
        internalConfig = new InternalBukkitConfig(config);
        Assertions.assertEquals((Object)"minecraft", (Object)internalConfig.getNamespace());
        Player player = this.enableWithNamespaces();
        CommandAPICommand command = (CommandAPICommand)new CommandAPICommand("test").executesPlayer(P_EXEC);
        command.register("");
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player, "test"));
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player, "minecraft:test"));
        CommandAPI.unregister((String)"test", (boolean)true);
        command.register("Command");
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player, "test"));
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player, "minecraft:test"));
        CommandAPI.unregister((String)"test", (boolean)true);
        command.register("test_123.-");
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player, "test"));
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player, "test_123.-:test"));
    }
}

