/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.PaperCommandRegistration;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.SpigotCommandRegistration;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreHolder;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_21_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.CraftSound;
import org.bukkit.craftbukkit.v1_21_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R3.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R3.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_21_R3.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.potion.CraftPotionEffectType;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;

public class NMS_1_21_R3
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final Field serverFunctionLibraryDispatcher;
    private static final boolean vanillaCommandDispatcherFieldExists;
    private static final SafeVarHandle<MinecraftServer, FuelValues> minecraftServerFuelValues;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(MinecraftKey key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public ArgumentType<?> _ArgumentAdvancement() {
        return ResourceKeyArgument.a((ResourceKey)Registries.bj);
    }

    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.aO);
    }

    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public final ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public ArgumentType<?> _ArgumentRecipe() {
        return ResourceKeyArgument.a((ResourceKey)Registries.bk);
    }

    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.aI);
    }

    public final Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getHelpMap()));
    }

    public String[] compatibleVersions() {
        return new String[]{"1.21.4"};
    }

    private static String serializeNMSItemStack(ItemStack is) {
        return new ArgumentPredicateItemStack(is.i(), is.d()).a((HolderLookup.a)COMMAND_BUILD_CONTEXT);
    }

    public final String convert(org.bukkit.inventory.ItemStack is) {
        return NMS_1_21_R3.serializeNMSItemStack(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)is));
    }

    public final String convert(ParticleData<?> particle) {
        ParticleParam particleOptions = CraftParticle.createParticleParam((org.bukkit.Particle)particle.particle(), (Object)particle.data());
        MinecraftKey particleKey = BuiltInRegistries.i.b((Object)particleOptions.a());
        Codec codec = particleOptions.a().c().codec();
        DataResult result = codec.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)particleOptions);
        NBTTagCompound particleOptionsTag = (NBTTagCompound)result.result().get();
        String dataString = particleOptionsTag.e().isEmpty() ? "" : particleOptionsTag.u_();
        return particleKey.toString() + dataString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runCommandFunction(CommandFunction<CommandListenerWrapper> commandFunction, CommandListenerWrapper css) {
        GameProfilerFiller profiler = Profiler.a();
        profiler.a(() -> "function " + String.valueOf(commandFunction.a()));
        AtomicInteger result = new AtomicInteger();
        CommandResultCallback onCommandResult = (succeeded, resultValue) -> result.set(resultValue);
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.a((NBTTagCompound)null, this.getBrigadierDispatcher());
            net.minecraft.commands.CommandDispatcher.a((CommandListenerWrapper)css, executioncontext -> ExecutionContext.a((ExecutionContext)executioncontext, (InstantiatedFunction)instantiatedFunction, (ExecutionCommandSource)css, (CommandResultCallback)onCommandResult));
        }
        catch (FunctionInstantiationException instantiatedFunction) {
        }
        catch (Exception exception) {
            LogUtils.getLogger().warn("Failed to execute function {}", (Object)commandFunction.a(), (Object)exception);
        }
        finally {
            profiler.c();
        }
        return result.get();
    }

    private final SimpleFunctionWrapper convertFunction(CommandFunction<CommandListenerWrapper> commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> this.runCommandFunction(commandFunction, (CommandListenerWrapper)css);
        String[] commands = new String[]{};
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.a((NBTTagCompound)null, this.getBrigadierDispatcher());
            List cArr = instantiatedFunction.b();
            commands = new String[cArr.size()];
            int size = cArr.size();
            for (int i = 0; i < size; ++i) {
                commands[i] = cArr.get(i).toString();
            }
        }
        catch (FunctionInstantiationException functionInstantiationException) {
            // empty catch block
        }
        return new SimpleFunctionWrapper(NMS_1_21_R3.fromResourceLocation(commandFunction.a()), appliedObj, commands);
    }

    public final void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentUtils.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ResourceKeyArgument.e(cmdCtx, (String)key).toBukkit();
    }

    public Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key), (HolderLookup.a)COMMAND_BUILD_CONTEXT));
    }

    public NamedTextColor getAdventureChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Integer color = ArgumentChatFormat.a(cmdCtx, (String)key).f();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    public final Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key), (HolderLookup.a)COMMAND_BUILD_CONTEXT));
    }

    public final Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        MinecraftKey resourceLocation = ResourceArgument.a(cmdCtx, (String)key, (ResourceKey)Registries.aI).h().a();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_21_R3.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    public final Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).e(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    public final BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)sender.getSource()));
    }

    public final BaseComponent[] getChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key), (HolderLookup.a)COMMAND_BUILD_CONTEXT));
    }

    public final World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key).getWorld();
    }

    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Enchantment enchantment = (Enchantment)ResourceArgument.g(cmdCtx, (String)key).a();
        MinecraftKey resource = ((MinecraftServer)this.getMinecraftServer()).ba().e(Registries.aO).b((Object)enchantment);
        return (org.bukkit.enchantments.Enchantment)Registry.ENCHANTMENT.get(NMS_1_21_R3.fromResourceLocation(resource));
    }

    public final Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument.b((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
            }
        }
        return object;
    }

    public final EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)EntityTypes.a((EntityTypes)((EntityTypes)ResourceArgument.e(cmdCtx, (String)key).a())).a());
    }

    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.DoubleRange range = ArgumentCriterionValue.a.a(cmdCtx, (String)key);
        Double lowBoxed = range.a().orElse(null);
        Double highBoxed = range.b().orElse(null);
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    public final FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CommandFunction commandFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction((CommandFunction<CommandListenerWrapper>)commandFunction), (Object)css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        MinecraftKey resourceLocation = MinecraftKey.a((String)key.getNamespace(), (String)key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).aE().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((CommandFunction<CommandListenerWrapper>)((CommandFunction)commandFunctionOptional.get()));
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aE().d()) {
            result.add(NMS_1_21_R3.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        Integer lowBoxed = range.a().orElse(null);
        Integer highBoxed = range.b().orElse(null);
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    public final org.bukkit.inventory.ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key);
        ItemStack item = input.a(1, false);
        return CraftItemStack.asBukkitCopy((ItemStack)item);
    }

    public final Predicate<org.bukkit.inventory.ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentItemPredicate.d predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return arg_0 -> NMS_1_21_R3.lambda$getItemStackPredicate$6((Predicate)predicate, arg_0);
    }

    public final Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.c(), (double)blockPos.d());
    }

    public final Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public final Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.c(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public final Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.b(cmdCtx, (String)key).a((CommandListenerWrapper)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public final LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftLootTable.minecraftToBukkit((MinecraftKey)ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key));
    }

    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return NMS_1_21_R3.fromResourceLocation(ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key));
    }

    public final ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        org.bukkit.Particle particle;
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            particle = CraftParticle.minecraftToBukkit((Particle)particleOptions.a());
        } else {
            particle = null;
        }
        if (particleOptions instanceof ParticleType) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((IBlockData)options.b()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.b().x() * 255.0f)), (int)((int)(options.b().y() * 255.0f)), (int)((int)(options.b().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.d()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((ItemStack)options.b()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData(particle, (Object)options.b());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData(particle, (Object)Float.valueOf(options.b()));
        }
        if (particleOptions instanceof ColorParticleOption) {
            ColorParticleOption options = (ColorParticleOption)particleOptions;
            return this.getParticleDataAsColorParticleOption(particle, options);
        }
        if (particleOptions instanceof TrailParticleOption) {
            TrailParticleOption options = (TrailParticleOption)particleOptions;
            return this.getParticleDataAsTrailParticleOption(cmdCtx, particle, options);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.Trail> getParticleDataAsTrailParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, org.bukkit.Particle particle, TrailParticleOption options) {
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).e();
        Vec3D target = options.b();
        Location targetLocation = new Location((World)level.getWorld(), target.d, target.e, target.f);
        Color color = Color.fromARGB((int)options.c());
        return new ParticleData(particle, (Object)new Particle.Trail(targetLocation, color, options.d()));
    }

    private ParticleData<Color> getParticleDataAsColorParticleOption(org.bukkit.Particle particle, ColorParticleOption options) {
        Color color = Color.fromARGB((int)((int)(options.e() * 255.0f)), (int)((int)(options.b() * 255.0f)), (int)((int)(options.c() * 255.0f)), (int)((int)(options.d() * 255.0f)));
        return new ParticleData(particle, (Object)color);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(org.bukkit.Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.b().x() * 255.0f)), (int)((int)(options.b().y() * 255.0f)), (int)((int)(options.b().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.c().x() * 255.0f)), (int)((int)(options.c().y() * 255.0f)), (int)((int)(options.c().z() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.d()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, org.bukkit.Particle particle, VibrationParticleOption options) {
        Vec3D origin = ((CommandListenerWrapper)cmdCtx.getSource()).d();
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.d, origin.e, origin.f);
        PositionSource positionSource = options.b();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.b()));
            return new ParticleData(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        Vec3D to = (Vec3D)positionSource2.a((net.minecraft.world.level.World)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.c()));
    }

    public Object getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.minecraftToBukkit((MobEffectList)((MobEffectList)ResourceArgument.f(cmdCtx, (String)key).a()));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> NMS_1_21_R3.fromResourceLocation(ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public final Recipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        RecipeHolder recipe = ResourceKeyArgument.d(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_21_R3.fromResourceLocation(recipe.a().b()), recipe.toBukkitRecipe());
    }

    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft((int)ArgumentScoreboardSlot.a(cmdCtx, (String)key).a());
    }

    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Collection scoreHolders = ArgumentScoreholder.b(cmdCtx, (String)key);
        HashSet<String> scoreHolderNames = new HashSet<String>();
        for (ScoreHolder scoreHolder : scoreHolders) {
            scoreHolderNames.add(scoreHolder.cI());
        }
        return scoreHolderNames;
    }

    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key).cI();
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        Vec3D pos = css.d();
        Vec2F rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        Entity proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                Optional soundEvent = BuiltInRegistries.b.c(soundResource);
                if (soundEvent.isEmpty()) {
                    yield null;
                }
                yield CraftSound.minecraftToBukkit((SoundEffect)((SoundEffect)((Holder.c)soundEvent.get()).a()));
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).aE();
                ICompletionProvider.a((Iterable)functionData.e(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.d(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).aI().e().stream().map(holder -> holder.a().a()), (SuggestionsBuilder)builder);
            case SuggestionProviders.SOUNDS -> CompletionProviders.b;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).aD().b().stream().map(AdvancementHolder::a), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).bc().a(Registries.bg), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> CompletionProviders.c;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = ((MinecraftServer)this.getMinecraftServer()).aE().b(MinecraftKey.a((String)key.getNamespace(), (String)key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (CommandFunction customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction((CommandFunction<CommandListenerWrapper>)customFunction);
        }
        return convertedCustomFunctions;
    }

    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aE().e()) {
            result.add(NMS_1_21_R3.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public final void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = ((MinecraftServer)this.getMinecraftServer()).aA;
        serverResources.b().d = ((MinecraftServer)this.getMinecraftServer()).aG();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aF().e());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aZ().D().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aF().c()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            ResourcePackRepository serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aF();
            ArrayList<IResourcePack> packResources = new ArrayList<IResourcePack>();
            for (String packID : collection) {
                ResourcePackLoader pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.f());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            ResourceManager resourceManager = new ResourceManager(EnumResourcePackType.b, packResources);
            CompletableFuture simpleReloadInstance = Reloadable.a((IResourceManager)resourceManager, (List)serverResources.b().f(), (Executor)((MinecraftServer)this.getMinecraftServer()).ay, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(Unit.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).aA.close();
            ((MinecraftServer)this.getMinecraftServer()).aA = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aF().b(collection);
            FeatureFlagSet enabledFeatures = ((MinecraftServer)this.getMinecraftServer()).aZ().D().b();
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aF().e();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aF().c());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aZ().a(new WorldDataConfiguration(new DataPackConfiguration((List)enabledIDs, disabledIDs), enabledFeatures));
            ((MinecraftServer)this.getMinecraftServer()).aA.b().g();
            ((MinecraftServer)this.getMinecraftServer()).aA.b().c().a(enabledFeatures);
            ((MinecraftServer)this.getMinecraftServer()).aY().a((IResourceManager)((MinecraftServer)this.getMinecraftServer()).aA.a());
            minecraftServerFuelValues.set((Object)((MinecraftServer)this.getMinecraftServer()), (Object)FuelValues.a((HolderLookup.a)((MinecraftServer)this.getMinecraftServer()).bb().a(), (FeatureFlagSet)enabledFeatures));
        });
        if (((MinecraftServer)this.getMinecraftServer()).bx()) {
            ((MinecraftServer)this.getMinecraftServer()).b(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json, (HolderLookup.a)COMMAND_BUILD_CONTEXT);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.W);
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.z);
    }

    public CommandRegistrationStrategy<CommandListenerWrapper> createCommandRegistrationStrategy() {
        Class<?> bukkitCommandNode_bukkitBrigCommand;
        if (vanillaCommandDispatcherFieldExists) {
            return new SpigotCommandRegistration(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).aG().a(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
        }
        try {
            bukkitCommandNode_bukkitBrigCommand = Class.forName("io.papermc.paper.command.brigadier.bukkit.BukkitCommandNode$BukkitBrigCommand");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Expected to find class", e);
        }
        return new PaperCommandRegistration(() -> ((MinecraftServer)this.getMinecraftServer()).aG().a(), node -> bukkitCommandNode_bukkitBrigCommand.isInstance(node.getCommand()));
    }

    private static /* synthetic */ boolean lambda$getItemStackPredicate$6(Predicate predicate, org.bukkit.inventory.ItemStack item) {
        return predicate.test(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item));
    }

    static {
        boolean fieldExists;
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = CommandBuildContext.a((HolderLookup.a)server2.getServer().ba(), (FeatureFlagSet)server2.getServer().aZ().D().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(EntitySelector.class, (String)"p", (String)"usesSelector");
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(CustomFunctionManager.class, (String)"h", (String)"dispatcher");
        try {
            MinecraftServer.class.getDeclaredField("vanillaCommandDispatcher");
            fieldExists = true;
        }
        catch (NoSuchFieldException | SecurityException e) {
            fieldExists = false;
        }
        vanillaCommandDispatcherFieldExists = fieldExists;
        minecraftServerFuelValues = SafeVarHandle.ofOrNull(MinecraftServer.class, (String)"aE", (String)"fuelValues", FuelValues.class);
    }
}

