/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.PaperCommandRegistration;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.SpigotCommandRegistration;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_20_R4.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R4.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftSound;
import org.bukkit.craftbukkit.v1_20_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R4.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R4.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R4.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_20_R4.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R4.potion.CraftPotionEffectType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;

public class NMS_1_20_R4
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final Field serverFunctionLibraryDispatcher;
    private static final boolean vanillaCommandDispatcherFieldExists;
    private static final el COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(alf key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return gh.a((el)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentBlockState() {
        return gi.a((el)COMMAND_BUILD_CONTEXT);
    }

    public ArgumentType<?> _ArgumentChatComponent() {
        return ey.a((el)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentEnchantment() {
        return fo.a((el)COMMAND_BUILD_CONTEXT, (ale)lq.u);
    }

    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> fc.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> fc.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> fc.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> fc.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public final ArgumentType<?> _ArgumentItemPredicate() {
        return hb.a((el)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentItemStack() {
        return gy.a((el)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentParticle() {
        return fm.a((el)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return fo.a((el)COMMAND_BUILD_CONTEXT, (ale)lq.az);
    }

    public final Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getHelpMap()));
    }

    public String[] compatibleVersions() {
        return new String[]{"1.20.5", "1.20.6"};
    }

    private static String serializeNMSItemStack(cur is) {
        kn patchedMap = kn.a((ki)kn.a, (kj)is.d());
        return new gz(is.h(), (ki)patchedMap).a((jk.a)COMMAND_BUILD_CONTEXT);
    }

    public final String convert(ItemStack is) {
        return NMS_1_20_R4.serializeNMSItemStack(CraftItemStack.asNMSCopy((ItemStack)is));
    }

    public final String convert(ParticleData<?> particle) {
        lg particleOptions = CraftParticle.createParticleParam((Particle)particle.particle(), (Object)particle.data());
        alf particleKey = lp.j.b((Object)particleOptions.a());
        Codec codec = particleOptions.a().c().codec();
        DataResult result = codec.encodeStart((DynamicOps)vg.a, (Object)particleOptions);
        us particleOptionsTag = (us)result.result().get();
        String dataString = particleOptionsTag.e().isEmpty() ? "" : particleOptionsTag.s_();
        return particleKey.toString() + dataString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runCommandFunction(ib<ep> commandFunction, ep css) {
        bnk profiler = ((MinecraftServer)this.getMinecraftServer()).aT();
        profiler.a(() -> "function " + String.valueOf(commandFunction.a()));
        AtomicInteger result = new AtomicInteger();
        em onCommandResult = (succeeded, resultValue) -> result.set(resultValue);
        try {
            id instantiatedFunction = commandFunction.a((us)null, this.getBrigadierDispatcher());
            eq.a((ep)css, executioncontext -> ho.a((ho)executioncontext, (id)instantiatedFunction, (er)css, (em)onCommandResult));
        }
        catch (es instantiatedFunction) {
        }
        catch (Exception exception) {
            LogUtils.getLogger().warn("Failed to execute function {}", (Object)commandFunction.a(), (Object)exception);
        }
        finally {
            profiler.c();
        }
        return result.get();
    }

    private final SimpleFunctionWrapper convertFunction(ib<ep> commandFunction) {
        ToIntFunction<ep> appliedObj = css -> this.runCommandFunction(commandFunction, (ep)css);
        String[] commands = new String[]{};
        try {
            id instantiatedFunction = commandFunction.a((us)null, this.getBrigadierDispatcher());
            List cArr = instantiatedFunction.b();
            commands = new String[cArr.size()];
            int size = cArr.size();
            for (int i = 0; i < size; ++i) {
                commands[i] = cArr.get(i).toString();
            }
        }
        catch (es es2) {
            // empty catch block
        }
        return new SimpleFunctionWrapper(NMS_1_20_R4.fromResourceLocation(commandFunction.a()), appliedObj, commands);
    }

    public final void createDispatcherFile(File file, CommandDispatcher<ep> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)im.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Advancement getAdvancement(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        return fq.a(cmdCtx, (String)key).toBukkit();
    }

    public Component getAdventureChat(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)xp.a.a((xp)fg.a(cmdCtx, (String)key), (jk.a)COMMAND_BUILD_CONTEXT));
    }

    public NamedTextColor getAdventureChatColor(CommandContext<ep> cmdCtx, String key) {
        Integer color = ex.a(cmdCtx, (String)key).f();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    public final Component getAdventureChatComponent(CommandContext<ep> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)xp.a.a((xp)ey.a(cmdCtx, (String)key), (jk.a)COMMAND_BUILD_CONTEXT));
    }

    public final Object getBiome(CommandContext<ep> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        alf resourceLocation = fo.a(cmdCtx, (String)key, (ale)lq.az).h().a();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_20_R4.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    public final Predicate<Block> getBlockPredicate(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = gh.a(cmdCtx, (String)key);
        return block -> predicate.test(new dsi((dcd)((ep)cmdCtx.getSource()).e(), new iz(block.getX(), block.getY(), block.getZ()), true));
    }

    public final BlockData getBlockState(CommandContext<ep> cmdCtx, String key) {
        return CraftBlockData.fromData((dse)gi.a(cmdCtx, (String)key).a());
    }

    public ep getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)sender.getSource()));
    }

    public final BaseComponent[] getChat(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)xp.a.a((xp)fg.a(cmdCtx, (String)key), (jk.a)COMMAND_BUILD_CONTEXT));
    }

    public final World getDimension(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        return fa.a(cmdCtx, (String)key).getWorld();
    }

    public final Enchantment getEnchantment(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        return (Enchantment)Registry.ENCHANTMENT.get(NMS_1_20_R4.fromResourceLocation(lp.f.b((Object)((dac)fo.g(cmdCtx, (String)key).a()))));
    }

    public final Object getEntitySelector(CommandContext<ep> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        he argument = (he)cmdCtx.getArgument(str, he.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (bsw entity : argument.b((ep)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw fc.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (arg player : argument.d((ep)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw fc.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.a((ep)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.c((ep)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
            }
        }
        return object;
    }

    public final EntityType getEntityType(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)btc.a((btc)((btc)fo.e(cmdCtx, (String)key).a())).a());
    }

    public FloatRange getFloatRange(CommandContext<ep> cmdCtx, String key) {
        de.c range = fn.a.a(cmdCtx, (String)key);
        Double lowBoxed = range.a().orElse(null);
        Double highBoxed = range.b().orElse(null);
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    public final FunctionWrapper[] getFunction(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        ep css = ((ep)cmdCtx.getSource()).a().b(2);
        for (ib commandFunction : gx.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction((ib<ep>)commandFunction), (Object)css, entity -> ((ep)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        alf resourceLocation = new alf(key.getNamespace(), key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).aF().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((ib<ep>)((ib)commandFunctionOptional.get()));
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (alf resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aF().d()) {
            result.add(NMS_1_20_R4.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public IntegerRange getIntRange(CommandContext<ep> cmdCtx, String key) {
        de.d range = fn.b.a(cmdCtx, (String)key);
        Integer lowBoxed = range.a().orElse(null);
        Integer highBoxed = range.b().orElse(null);
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    public final ItemStack getItemStack(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        gz input = gy.a(cmdCtx, (String)key);
        cur item = input.a(1, false);
        return CraftItemStack.asBukkitCopy((cur)item);
    }

    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        hb.d predicate = hb.a(cmdCtx, (String)key);
        return arg_0 -> NMS_1_20_R4.lambda$getItemStackPredicate$6((Predicate)predicate, arg_0);
    }

    public final Location2D getLocation2DBlock(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        aqv blockPos = gm.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((ep)cmdCtx.getSource()), (double)blockPos.c(), (double)blockPos.d());
    }

    public final Location2D getLocation2DPrecise(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        evs vecPos = gr.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((ep)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public final Location getLocationBlock(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        iz blockPos = gl.c(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((ep)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public final Location getLocationPrecise(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        evt vecPos = gs.b(cmdCtx, (String)key).a((ep)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((ep)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public final LootTable getLootTable(CommandContext<ep> cmdCtx, String key) {
        return CraftLootTable.minecraftToBukkit((alf)fq.c(cmdCtx, (String)key));
    }

    public NamespacedKey getMinecraftKey(CommandContext<ep> cmdCtx, String key) {
        return NMS_1_20_R4.fromResourceLocation(fq.c(cmdCtx, (String)key));
    }

    public final ParticleData<?> getParticle(CommandContext<ep> cmdCtx, String key) {
        Particle particle;
        lg particleOptions = fm.a(cmdCtx, (String)key);
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            particle = CraftParticle.minecraftToBukkit((lh)particleOptions.a());
        } else {
            particle = null;
        }
        if (particleOptions instanceof lm) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof la) {
            la options = (la)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((dse)options.b()));
        }
        if (particleOptions instanceof lc) {
            lc options = (lc)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ld) {
            ld options = (ld)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.b().x() * 255.0f)), (int)((int)(options.b().y() * 255.0f)), (int)((int)(options.b().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.d()));
        }
        if (particleOptions instanceof le) {
            le options = (le)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((cur)options.b()));
        }
        if (particleOptions instanceof ln) {
            ln options = (ln)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ll) {
            ll options = (ll)particleOptions;
            return new ParticleData(particle, (Object)options.b());
        }
        if (particleOptions instanceof lk) {
            lk options = (lk)particleOptions;
            return new ParticleData(particle, (Object)Float.valueOf(options.b()));
        }
        if (particleOptions instanceof lb) {
            lb options = (lb)particleOptions;
            return this.getParticleDataAsColorParticleOption(particle, options);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Color> getParticleDataAsColorParticleOption(Particle particle, lb options) {
        Color color = Color.fromARGB((int)((int)(options.e() * 255.0f)), (int)((int)(options.b() * 255.0f)), (int)((int)(options.c() * 255.0f)), (int)((int)(options.d() * 255.0f)));
        return new ParticleData(particle, (Object)color);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, lc options) {
        Color color = Color.fromRGB((int)((int)(options.b().x() * 255.0f)), (int)((int)(options.b().y() * 255.0f)), (int)((int)(options.b().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.c().x() * 255.0f)), (int)((int)(options.c().y() * 255.0f)), (int)((int)(options.c().z() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.d()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<ep> cmdCtx, Particle particle, ln options) {
        evt origin = ((ep)cmdCtx.getSource()).d();
        arf level = ((ep)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        dxb dxb2 = options.b();
        if (!(dxb2 instanceof dwt)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.b()));
            return new ParticleData(particle, null);
        }
        dwt positionSource = (dwt)dxb2;
        evt to = (evt)positionSource.a((dca)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.c()));
    }

    public Object getPotionEffect(CommandContext<ep> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.minecraftToBukkit((bsc)((bsc)fo.f(cmdCtx, (String)key).a()));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> NMS_1_20_R4.fromResourceLocation(fq.c(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public final Recipe getRecipe(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        cyz recipe = fq.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_20_R4.fromResourceLocation(recipe.a()), recipe.toBukkitRecipe());
    }

    public ScoreboardSlot getScoreboardSlot(CommandContext<ep> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft((int)fv.a(cmdCtx, (String)key).a());
    }

    public Collection<String> getScoreHolderMultiple(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        Collection scoreHolders = fu.b(cmdCtx, (String)key);
        HashSet<String> scoreHolderNames = new HashSet<String>();
        for (eww scoreHolder : scoreHolders) {
            scoreHolderNames.add(scoreHolder.cB());
        }
        return scoreHolderNames;
    }

    public String getScoreHolderSingle(CommandContext<ep> cmdCtx, String key) throws CommandSyntaxException {
        return fu.a(cmdCtx, (String)key).cB();
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<ep> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        ep css = (ep)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        evt pos = css.d();
        evs rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        bsw proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<ep> cmdCtx, String key, ArgumentSubType subType) {
        alf soundResource = fq.c(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                avz soundEvent = (avz)lp.b.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.minecraftToBukkit((avz)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public SuggestionProvider<ep> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                alu functionData = ((MinecraftServer)this.getMinecraftServer()).aF();
                eu.a((Iterable)functionData.e(), (SuggestionsBuilder)builder, (String)"#");
                return eu.a((Iterable)functionData.d(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> io.b;
            case SuggestionProviders.SOUNDS -> io.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> eu.a(((MinecraftServer)this.getMinecraftServer()).aE().b().stream().map(af::a), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> eu.a((Iterable)((MinecraftServer)this.getMinecraftServer()).be().a(lq.aU), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> io.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).aF().b(new alf(key.getNamespace(), key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (ib customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction((ib<ep>)customFunction);
        }
        return convertedCustomFunctions;
    }

    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (alf resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aF().e()) {
            result.add(NMS_1_20_R4.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public World getWorldForCSS(ep css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public final void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.a serverResources = ((MinecraftServer)this.getMinecraftServer()).az;
        serverResources.b().e = ((MinecraftServer)this.getMinecraftServer()).aH();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aG().d());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).bb().D().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aG().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            aua serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aG();
            ArrayList<atb> packResources = new ArrayList<atb>();
            for (String packID : collection) {
                atx pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.f());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            aui resourceManager = new aui(atd.b, packResources);
            CompletableFuture simpleReloadInstance = auv.a((aup)resourceManager, (List)serverResources.b().f(), (Executor)((MinecraftServer)this.getMinecraftServer()).ax, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(bac.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).az.close();
            ((MinecraftServer)this.getMinecraftServer()).az = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aG().b(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aG().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aG().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).bb().a(new dcu(new dbo((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).bb().D().b()));
            ((MinecraftServer)this.getMinecraftServer()).az.b().g();
            ((MinecraftServer)this.getMinecraftServer()).ba().a((aup)((MinecraftServer)this.getMinecraftServer()).az.a());
        });
        if (((MinecraftServer)this.getMinecraftServer()).bw()) {
            ((MinecraftServer)this.getMinecraftServer()).c(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public Message generateMessageFromJson(String json) {
        return xp.a.a((String)json, (jk.a)COMMAND_BUILD_CONTEXT);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return fo.a((el)COMMAND_BUILD_CONTEXT, (ale)lq.R);
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return fo.a((el)COMMAND_BUILD_CONTEXT, (ale)lq.v);
    }

    public CommandRegistrationStrategy<ep> createCommandRegistrationStrategy() {
        Class<?> bukkitCommandNode_bukkitBrigCommand;
        if (vanillaCommandDispatcherFieldExists) {
            return new SpigotCommandRegistration(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).aH().a(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
        }
        try {
            bukkitCommandNode_bukkitBrigCommand = Class.forName("io.papermc.paper.command.brigadier.bukkit.BukkitCommandNode$BukkitBrigCommand");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Expected to find class", e);
        }
        return new PaperCommandRegistration(() -> ((MinecraftServer)this.getMinecraftServer()).aH().a(), node -> bukkitCommandNode_bukkitBrigCommand.isInstance(node.getCommand()));
    }

    private static /* synthetic */ boolean lambda$getItemStackPredicate$6(Predicate predicate, ItemStack item) {
        return predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    static {
        boolean fieldExists;
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = el.a((jk.a)server2.getServer().bc(), (cpn)server2.getServer().bb().D().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(he.class, (String)"p", (String)"usesSelector");
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(alt.class, (String)"g", (String)"dispatcher");
        try {
            MinecraftServer.class.getDeclaredField("vanillaCommandDispatcher");
            fieldExists = true;
        }
        catch (NoSuchFieldException | SecurityException e) {
            fieldExists = false;
        }
        vanillaCommandDispatcherFieldExists = fieldExists;
    }
}

