/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_20_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftSound;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R3.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_20_R3.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionEffectType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;

public class NMS_1_20_R3
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final SafeVarHandle<fz, sn> itemInput;
    private static final Field serverFunctionLibraryDispatcher;
    private static final dn COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(ahg key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return fi.a((dn)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentBlockState() {
        return fj.a((dn)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentEnchantment() {
        return er.a((dn)COMMAND_BUILD_CONTEXT, (ahf)ke.t);
    }

    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ef.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ef.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ef.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ef.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public final ArgumentType<?> _ArgumentItemPredicate() {
        return gb.a((dn)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentItemStack() {
        return fy.a((dn)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentParticle() {
        return ep.a((dn)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return er.a((dn)COMMAND_BUILD_CONTEXT, (ahf)ke.at);
    }

    public final Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getHelpMap()));
    }

    public String[] compatibleVersions() {
        return new String[]{"1.20.3", "1.20.4"};
    }

    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).w().t_();
    }

    public final String convert(ParticleData<?> particle) {
        return CraftParticle.createParticleParam((Particle)particle.particle(), (Object)particle.data()).a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runCommandFunction(hb<ds> commandFunction, ds css) {
        bgs profiler = ((MinecraftServer)this.getMinecraftServer()).aR();
        profiler.a(() -> "function " + String.valueOf(commandFunction.a()));
        AtomicInteger result = new AtomicInteger();
        dp onCommandResult = (succeeded, resultValue) -> result.set(resultValue);
        try {
            hd instantiatedFunction = commandFunction.a((sn)null, this.getBrigadierDispatcher(), (Object)css);
            dt.a((ds)css, executioncontext -> go.a((go)executioncontext, (hd)instantiatedFunction, (du)css, (dp)onCommandResult));
        }
        catch (dv instantiatedFunction) {
        }
        catch (Exception exception) {
            LogUtils.getLogger().warn("Failed to execute function {}", (Object)commandFunction.a(), (Object)exception);
        }
        finally {
            profiler.c();
        }
        return result.get();
    }

    private final SimpleFunctionWrapper convertFunction(hb<ds> commandFunction) {
        ToIntFunction<ds> appliedObj = css -> this.runCommandFunction(commandFunction, (ds)css);
        String[] commands = new String[]{};
        try {
            hd instantiatedFunction = commandFunction.a((sn)null, this.getBrigadierDispatcher(), null);
            List cArr = instantiatedFunction.b();
            commands = new String[cArr.size()];
            int size = cArr.size();
            for (int i = 0; i < size; ++i) {
                commands[i] = cArr.get(i).toString();
            }
        }
        catch (dv dv2) {
            // empty catch block
        }
        return new SimpleFunctionWrapper(NMS_1_20_R3.fromResourceLocation(commandFunction.a()), appliedObj, commands);
    }

    public final void createDispatcherFile(File file, CommandDispatcher<ds> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)hl.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Advancement getAdvancement(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        return et.a(cmdCtx, (String)key).toBukkit();
    }

    public NamedTextColor getAdventureChatColor(CommandContext<ds> cmdCtx, String key) {
        Integer color = ea.a(cmdCtx, (String)key).f();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    public final Component getAdventureChatComponent(CommandContext<ds> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)vf.a.a((vf)eb.a(cmdCtx, (String)key)));
    }

    public final Object getBiome(CommandContext<ds> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        ahg resourceLocation = er.a(cmdCtx, (String)key, (ahf)ke.at).g().a();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_20_R3.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    public final Predicate<Block> getBlockPredicate(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = fi.a(cmdCtx, (String)key);
        return block -> predicate.test(new djl((cts)((ds)cmdCtx.getSource()).e(), new hx(block.getX(), block.getY(), block.getZ()), true));
    }

    public final BlockData getBlockState(CommandContext<ds> cmdCtx, String key) {
        return CraftBlockData.fromData((djh)fj.a(cmdCtx, (String)key).a());
    }

    public final CommandDispatcher<ds> getResourcesDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).aE().a();
    }

    public ds getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)sender.getSource()));
    }

    public final World getDimension(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        return ed.a(cmdCtx, (String)key).getWorld();
    }

    public final Enchantment getEnchantment(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        return (Enchantment)Registry.ENCHANTMENT.get(NMS_1_20_R3.fromResourceLocation(kd.f.b((Object)((crj)er.g(cmdCtx, (String)key).a()))));
    }

    public final Object getEntitySelector(CommandContext<ds> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        ge argument = (ge)cmdCtx.getArgument(str, ge.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (blv entity : argument.b((ds)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ef.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (ane player : argument.d((ds)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ef.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.a((ds)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.c((ds)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
            }
        }
        return object;
    }

    public final EntityType getEntityType(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)blz.a((blz)((blz)er.e(cmdCtx, (String)key).a())).a());
    }

    public FloatRange getFloatRange(CommandContext<ds> cmdCtx, String key) {
        ck.c range = eq.a.a(cmdCtx, (String)key);
        Double lowBoxed = range.a().orElse(null);
        Double highBoxed = range.b().orElse(null);
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    public final FunctionWrapper[] getFunction(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        ds css = ((ds)cmdCtx.getSource()).a().b(2);
        for (hb commandFunction : fx.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction((hb<ds>)commandFunction), (Object)css, entity -> ((ds)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        ahg resourceLocation = new ahg(key.getNamespace(), key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).aC().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((hb<ds>)((hb)commandFunctionOptional.get()));
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (ahg resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aC().d()) {
            result.add(NMS_1_20_R3.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public IntegerRange getIntRange(CommandContext<ds> cmdCtx, String key) {
        ck.d range = eq.b.a(cmdCtx, (String)key);
        Integer lowBoxed = range.a().orElse(null);
        Integer highBoxed = range.b().orElse(null);
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    public final ItemStack getItemStack(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        fz input = fy.a(cmdCtx, (String)key);
        cmy itemWithMaybeTag = input.a(1, false);
        sn tag = (sn)itemInput.get((Object)input);
        if (tag != null) {
            byte count = tag.f("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((cmy)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((cmy)itemWithMaybeTag));
        return result;
    }

    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = gb.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public final Location2D getLocation2DBlock(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        amt blockPos = fn.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((ds)cmdCtx.getSource()), (double)blockPos.c(), (double)blockPos.d());
    }

    public final Location2D getLocation2DPrecise(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        els vecPos = fs.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((ds)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public final Location getLocationBlock(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        hx blockPos = fm.c(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((ds)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public final Location getLocationPrecise(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        elt vecPos = ft.b(cmdCtx, (String)key).a((ds)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((ds)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public final LootTable getLootTable(CommandContext<ds> cmdCtx, String key) {
        ahg resourceLocation = et.e(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_20_R3.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).aJ().getLootTable(resourceLocation));
    }

    public final ParticleData<?> getParticle(CommandContext<ds> cmdCtx, String key) {
        jv particleOptions = ep.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.minecraftToBukkit((jw)particleOptions.b());
        if (particleOptions instanceof ka) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof jp) {
            jp options = (jp)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((djh)options.c()));
        }
        if (particleOptions instanceof jq) {
            jq options = (jq)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof jr) {
            jr options = (jr)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof jt) {
            jt options = (jt)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((cmy)options.c()));
        }
        if (particleOptions instanceof kb) {
            kb options = (kb)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof jz) {
            jz options = (jz)particleOptions;
            return new ParticleData(particle, (Object)options.c());
        }
        if (particleOptions instanceof jy) {
            jy options = (jy)particleOptions;
            return new ParticleData(particle, (Object)Float.valueOf(options.c()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, jq options) {
        Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().x() * 255.0f)), (int)((int)(options.d().y() * 255.0f)), (int)((int)(options.d().z() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<ds> cmdCtx, Particle particle, kb options) {
        elt origin = ((ds)cmdCtx.getSource()).d();
        and level = ((ds)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        dnv dnv2 = options.c();
        if (!(dnv2 instanceof dnn)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.c()));
            return new ParticleData(particle, null);
        }
        dnn positionSource = (dnn)dnv2;
        elt to = (elt)positionSource.a((ctp)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.d()));
    }

    public Object getPotionEffect(CommandContext<ds> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.minecraftToBukkit((blg)((blg)er.f(cmdCtx, (String)key).a()));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> NMS_1_20_R3.fromResourceLocation(et.e(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public final Recipe getRecipe(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        cqe recipe = et.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_20_R3.fromResourceLocation(recipe.a()), recipe.toBukkitRecipe());
    }

    public ScoreboardSlot getScoreboardSlot(CommandContext<ds> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft((int)ex.a(cmdCtx, (String)key).a());
    }

    public Collection<String> getScoreHolderMultiple(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        Collection scoreHolders = ew.b(cmdCtx, (String)key);
        HashSet<String> scoreHolderNames = new HashSet<String>();
        for (emw scoreHolder : scoreHolders) {
            scoreHolderNames.add(scoreHolder.cy());
        }
        return scoreHolderNames;
    }

    public String getScoreHolderSingle(CommandContext<ds> cmdCtx, String key) throws CommandSyntaxException {
        return ew.a(cmdCtx, (String)key).cy();
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<ds> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        ds css = (ds)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        elt pos = css.d();
        els rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        blv proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<ds> cmdCtx, String key, ArgumentSubType subType) {
        ahg soundResource = et.e(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                arr soundEvent = (arr)kd.b.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.minecraftToBukkit((arr)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public SuggestionProvider<ds> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                ahu functionData = ((MinecraftServer)this.getMinecraftServer()).aC();
                dx.a((Iterable)functionData.e(), (SuggestionsBuilder)builder, (String)"#");
                return dx.a((Iterable)functionData.d(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> hn.b;
            case SuggestionProviders.SOUNDS -> hn.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> dx.a(((MinecraftServer)this.getMinecraftServer()).aB().b().stream().map(af::a), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> dx.a((Iterable)((MinecraftServer)this.getMinecraftServer()).aJ().a(ehb.c), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> hn.d;
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> dx.a((Iterable)kd.d.e(), (SuggestionsBuilder)builder);
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).aC().b(new ahg(key.getNamespace(), key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (hb customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction((hb<ds>)customFunction);
        }
        return convertedCustomFunctions;
    }

    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (ahg resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aC().e()) {
            result.add(NMS_1_20_R3.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public World getWorldForCSS(ds css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public final boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public Command wrapToVanillaCommandWrapper(CommandNode<ds> node) {
        return new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node);
    }

    public boolean isBukkitCommandWrapper(CommandNode<ds> node) {
        return node.getCommand() instanceof BukkitCommandWrapper;
    }

    public final void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.a serverResources = ((MinecraftServer)this.getMinecraftServer()).ax;
        serverResources.b().d = ((MinecraftServer)this.getMinecraftServer()).aE();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aD().d());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aY().F().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aD().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        iu.b registryAccess = ((MinecraftServer)this.getMinecraftServer()).aZ();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            apt serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aD();
            ArrayList<aow> packResources = new ArrayList<aow>();
            for (String packID : collection) {
                apq pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.e());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            aqb resourceManager = new aqb(aox.b, packResources);
            CompletableFuture simpleReloadInstance = aqo.a((aqi)resourceManager, (List)serverResources.b().f(), (Executor)((MinecraftServer)this.getMinecraftServer()).av, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(avs.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).ax.close();
            ((MinecraftServer)this.getMinecraftServer()).ax = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aD().a(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aD().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aD().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aY().a(new cuj(new ctd((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).aY().F().b()));
            ((MinecraftServer)this.getMinecraftServer()).ax.b().a((iu)registryAccess);
            ((MinecraftServer)this.getMinecraftServer()).aX().a((aqi)((MinecraftServer)this.getMinecraftServer()).ax.a());
        });
        if (((MinecraftServer)this.getMinecraftServer()).bq()) {
            ((MinecraftServer)this.getMinecraftServer()).c(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public Message generateMessageFromJson(String json) {
        return vf.a.a((String)json);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return er.a((dn)COMMAND_BUILD_CONTEXT, (ahf)ke.Q);
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return er.a((dn)COMMAND_BUILD_CONTEXT, (ahf)ke.u);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = dn.a((iu)server2.getServer().aZ(), (chs)server2.getServer().aY().F().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(ge.class, (String)"p", (String)"usesSelector");
        itemInput = SafeVarHandle.ofOrNull(fz.class, (String)"c", (String)"tag", sn.class);
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(aht.class, (String)"g", (String)"dispatcher");
    }
}

