/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.PreviewInfo;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.AbstractPlayer;
import dev.jorel.commandapi.commandsenders.BukkitPlayer;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.wrappers.PreviewableFunction;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.ServerboundChatPreviewPacket;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class NMS_1_19_Common_ChatPreviewHandler
extends ChannelDuplexHandler {
    protected final CommandAPIBukkit<CommandListenerWrapper> platform;
    protected final Plugin plugin;
    protected final Player player;
    protected final NetworkManager connection;

    protected NMS_1_19_Common_ChatPreviewHandler(CommandAPIBukkit<CommandListenerWrapper> platform, Plugin plugin, Player player) {
        this.platform = platform;
        this.plugin = plugin;
        this.player = player;
        this.connection = ((CraftPlayer)player).getHandle().b.b;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ServerboundChatPreviewPacket chatPreview;
        if (msg instanceof ServerboundChatPreviewPacket && !(chatPreview = (ServerboundChatPreviewPacket)msg).c().isEmpty() && chatPreview.c().charAt(0) == '/' && InitialParse.processChatPreviewQuery((String)chatPreview.c(), this.platform, (Player)this.player).preview.isPresent()) {
            this.handleChatPreviewPacket(chatPreview);
            return;
        }
        super.channelRead(ctx, msg);
    }

    protected abstract void handleChatPreviewPacket(ServerboundChatPreviewPacket var1);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IChatMutableComponent parseChatPreviewQuery(String chatPreviewQuery) {
        String jsonToSend;
        void var9_15;
        InitialParse ip = InitialParse.processChatPreviewQuery(chatPreviewQuery, this.platform, this.player);
        Optional<PreviewableFunction<?>> preview = ip.preview;
        if (preview.isEmpty()) {
            return null;
        }
        String fullInput = ip.fullInput;
        ParseResults<CommandListenerWrapper> results = ip.results;
        List<String> path = ip.path;
        String input = ((ParsedCommandNode)results.getContext().getNodes().get(results.getContext().getNodes().size() - 1)).getRange().get(fullInput);
        try {
            PreviewInfo previewInfo;
            if (CommandAPIHandler.getInstance().lookupPreviewableLegacyStatus(path)) {
                try {
                    parsedInput = this.platform.getChat(results.getContext().build(fullInput), path.get(path.size() - 1));
                }
                catch (CommandSyntaxException e) {
                    throw new WrapperCommandSyntaxException(e);
                }
                previewInfo = new PreviewInfo((AbstractPlayer)new BukkitPlayer(this.player), input, chatPreviewQuery, (Object)parsedInput);
            } else {
                try {
                    parsedInput = this.platform.getAdventureChat(results.getContext().build(fullInput), path.get(path.size() - 1));
                }
                catch (CommandSyntaxException e) {
                    throw new WrapperCommandSyntaxException(e);
                }
                previewInfo = new PreviewInfo((AbstractPlayer)new BukkitPlayer(this.player), input, chatPreviewQuery, (Object)parsedInput);
            }
            Object object = preview.get().generatePreview(previewInfo);
        }
        catch (WrapperCommandSyntaxException e) {
            BaseComponent[] baseComponentArray = TextComponent.fromLegacyText((String)(e.getMessage() == null ? "" : e.getMessage()));
        }
        if (var9_15 == null) throw new NullPointerException("Returned value from chat preview was null");
        if (var9_15 instanceof BaseComponent[]) {
            BaseComponent[] baseComponent = (BaseComponent[])var9_15;
            jsonToSend = ComponentSerializer.toString((BaseComponent[])baseComponent);
            return IChatBaseComponent.ChatSerializer.a((String)jsonToSend);
        } else {
            if (!this.platform.getPaper().isPaperPresent()) throw new IllegalArgumentException("Unexpected type returned from chat preview, got: " + var9_15.getClass().getSimpleName());
            if (!(var9_15 instanceof Component)) throw new IllegalArgumentException("Unexpected type returned from chat preview, got: " + var9_15.getClass().getSimpleName());
            Component adventureComponent = (Component)var9_15;
            jsonToSend = (String)GsonComponentSerializer.gson().serialize(adventureComponent);
        }
        return IChatBaseComponent.ChatSerializer.a((String)jsonToSend);
    }

    private record InitialParse(String fullInput, ParseResults<CommandListenerWrapper> results, List<String> path, Optional<PreviewableFunction<?>> preview) {
        private static InitialParse cachedResult = null;

        public static InitialParse processChatPreviewQuery(String chatPreviewQuery, CommandAPIBukkit<CommandListenerWrapper> platform, Player player) {
            String fullInput = chatPreviewQuery.substring(1);
            if (cachedResult != null && InitialParse.cachedResult.fullInput.equals(fullInput)) {
                return cachedResult;
            }
            ParseResults results = platform.getBrigadierDispatcher().parse(fullInput, (Object)((CommandListenerWrapper)platform.getBrigadierSourceFromCommandSender((AbstractCommandSender)new BukkitPlayer(player))));
            ArrayList<String> path = new ArrayList<String>();
            for (ParsedCommandNode commandNode : results.getContext().getNodes()) {
                path.add(commandNode.getNode().getName());
            }
            Optional preview = CommandAPIHandler.getInstance().lookupPreviewable(path);
            cachedResult = new InitialParse(fullInput, (ParseResults<CommandListenerWrapper>)results, path, preview);
            return cachedResult;
        }
    }
}

