/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.nms.NMS_1_17_Common;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.ServerResources;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import org.bukkit.Bukkit;

public class NMS_1_17_R1
extends NMS_1_17_Common {
    private static final Field serverFunctionLibraryDispatcher = CommandAPIHandler.getField(ServerFunctionLibrary.class, (String)"i", (String)"dispatcher");

    public String[] compatibleVersions() {
        return new String[]{"1.17.1"};
    }

    public void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        ServerResources serverResources = ((MinecraftServer)this.getMinecraftServer()).resources;
        serverResources.commands = ((MinecraftServer)this.getMinecraftServer()).getCommands();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.getFunctionLibrary(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        CompletableFuture unitCompletableFuture = ((ReloadableResourceManager)serverResources.getResourceManager()).reload(Util.backgroundExecutor(), Runnable::run, ((MinecraftServer)this.getMinecraftServer()).getPackRepository().openAllSelected(), CompletableFuture.completedFuture(null));
        CompletionStage completablefuture = ((CompletableFuture)unitCompletableFuture.whenComplete((u, t) -> {
            if (t != null) {
                serverResources.close();
            }
        })).thenApply(u -> serverResources);
        try {
            ((ServerResources)((CompletableFuture)completablefuture).get()).updateGlobals();
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (InterruptedException e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }
}

