/*
 * Decompiled with CFR 0.152.
 */
package dev.caceresenzo.recaptcha.spring.web;

import dev.caceresenzo.recaptcha.spring.web.annotation.ChallengeResponseLocation;
import jakarta.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.MissingRequestHeaderException;
import org.springframework.web.bind.MissingServletRequestParameterException;

public record ReCaptchaV2ValidatorDefaults(@NonNull ChallengeResponseLocation location, @NonNull String headerName, @NonNull String queryParameterName) {
    private static final MethodParameter HEADER_METHOD = ReCaptchaV2ValidatorDefaults.getRecaptchaHeaderMethod();

    public ReCaptchaV2ValidatorDefaults(@NonNull ChallengeResponseLocation location, @NonNull String headerName, @NonNull String queryParameterName) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (headerName == null) {
            throw new NullPointerException("headerName is marked non-null but is null");
        }
        if (queryParameterName == null) {
            throw new NullPointerException("queryParameterName is marked non-null but is null");
        }
        if (ChallengeResponseLocation.DEFAULT.equals((Object)location)) {
            throw new IllegalArgumentException("default location must be specified");
        }
    }

    public String resolve(ChallengeResponseLocation location, String name, HttpServletRequest request) {
        location = this.resolveLocation(location);
        name = this.resolveName(location, name);
        String value = switch (location) {
            default -> throw new IncompatibleClassChangeError();
            case ChallengeResponseLocation.HEADER -> request.getHeader(name);
            case ChallengeResponseLocation.QUERY -> request.getParameter(name);
            case ChallengeResponseLocation.DEFAULT -> throw new IllegalStateException();
        };
        if (value != null && !value.isBlank()) {
            return value;
        }
        throw switch (location) {
            default -> throw new IncompatibleClassChangeError();
            case ChallengeResponseLocation.HEADER -> new MissingRequestHeaderException(name, HEADER_METHOD);
            case ChallengeResponseLocation.QUERY -> new MissingServletRequestParameterException(name, String.class.getSimpleName());
            case ChallengeResponseLocation.DEFAULT -> new IllegalStateException();
        };
    }

    public ChallengeResponseLocation resolveLocation(ChallengeResponseLocation location) {
        if (ChallengeResponseLocation.DEFAULT.equals((Object)location)) {
            return this.location;
        }
        return location;
    }

    public String resolveName(ChallengeResponseLocation location, String name) {
        if (name != null && !name.isBlank()) {
            return name;
        }
        return switch (location) {
            default -> throw new IncompatibleClassChangeError();
            case ChallengeResponseLocation.HEADER -> this.headerName;
            case ChallengeResponseLocation.QUERY -> this.queryParameterName;
            case ChallengeResponseLocation.DEFAULT -> throw new IllegalArgumentException("unknown name for default location");
        };
    }

    private static void recaptchaHeader(String header) {
    }

    private static MethodParameter getRecaptchaHeaderMethod() {
        return new MethodParameter(ReCaptchaV2ValidatorDefaults.class.getDeclaredMethod("recaptchaHeader", String.class), 0);
    }
}

