/*
 * Decompiled with CFR 0.152.
 */
package dev.caceresenzo.recaptcha.spring.web;

import dev.caceresenzo.recaptcha.spring.web.ReCaptchaV2ValidatorDefaults;
import dev.caceresenzo.recaptcha.spring.web.annotation.ReCaptchaV2;
import dev.caceresenzo.recaptcha.v2.ReCaptchaV2Validator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import lombok.Generated;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class ReCaptchaV2AnnotationInterceptor
implements HandlerInterceptor {
    private final ReCaptchaV2Validator validator;
    private final ReCaptchaV2ValidatorDefaults defaults;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        ReCaptchaV2 annotation = method.getAnnotation(ReCaptchaV2.class);
        if (annotation == null) {
            return true;
        }
        String challengeResponse = this.defaults.resolve(annotation.location(), annotation.name(), request);
        this.validator.verify(challengeResponse).orThrows();
        return true;
    }

    @Generated
    public ReCaptchaV2AnnotationInterceptor(ReCaptchaV2Validator validator, ReCaptchaV2ValidatorDefaults defaults) {
        this.validator = validator;
        this.defaults = defaults;
    }
}

