/*
 * Decompiled with CFR 0.152.
 */
package dev.caceresenzo.recaptcha.spring.boot.autoconfigure;

import dev.caceresenzo.recaptcha.spring.boot.autoconfigure.ReCaptchaAnnotationWebAutoConfiguration;
import dev.caceresenzo.recaptcha.spring.boot.autoconfigure.ReCaptchaV2Properties;
import dev.caceresenzo.recaptcha.spring.web.ReCaptchaV2ValidatorDefaults;
import dev.caceresenzo.recaptcha.v2.ReCaptchaV2Validator;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ReCaptchaV2Properties.class})
@AutoConfigureBefore(value={ReCaptchaAnnotationWebAutoConfiguration.class})
public class ReCaptchaV2AutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReCaptchaV2AutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(value={"recaptcha.v2.secret-key"})
    @ConditionalOnMissingBean
    ReCaptchaV2Validator reCaptchaVerifier(ReCaptchaV2Properties properties) throws IOException {
        log.info("Configuring reCAPTCHA v2");
        return ReCaptchaV2Validator.builder().secretKey(properties.getSecretKey()).build();
    }

    @Bean
    ReCaptchaV2ValidatorDefaults reCaptchaV2ValidatorDefaults(ReCaptchaV2Properties properties) throws IOException {
        ReCaptchaV2Properties.WebProperties web = properties.getWeb();
        return new ReCaptchaV2ValidatorDefaults(web.getLocation(), web.getHeaderName(), web.getQueryParameterName());
    }
}

