/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.util.tokenize;

import org.jetbrains.annotations.NotNull;
import revxrsal.commands.command.ArgumentParser;
import revxrsal.commands.command.ArgumentStack;
import revxrsal.commands.exception.ArgumentParseException;

public final class QuotedStringTokenizer
implements ArgumentParser {
    public static final QuotedStringTokenizer INSTANCE = new QuotedStringTokenizer();
    private static final int CHAR_BACKSLASH = 92;
    private static final int CHAR_SINGLE_QUOTE = 39;
    private static final int CHAR_DOUBLE_QUOTE = 34;

    private QuotedStringTokenizer() {
    }

    @Override
    public ArgumentStack parse(@NotNull String arguments) throws ArgumentParseException {
        if (arguments.length() == 0) {
            return ArgumentStack.empty();
        }
        TokenizerState state = new TokenizerState(arguments);
        ArgumentStack returnedArgs = ArgumentStack.empty();
        while (state.hasMore()) {
            this.skipWhiteSpace(state);
            String arg = this.nextArg(state);
            returnedArgs.add(arg);
        }
        return returnedArgs;
    }

    private void skipWhiteSpace(TokenizerState state) throws ArgumentParseException {
        if (!state.hasMore()) {
            return;
        }
        while (state.hasMore() && Character.isWhitespace(state.peek())) {
            state.next();
        }
    }

    private String nextArg(TokenizerState state) throws ArgumentParseException {
        StringBuilder argBuilder = new StringBuilder();
        if (state.hasMore()) {
            int codePoint = state.peek();
            if (codePoint == 34 || codePoint == 39) {
                this.parseQuotedString(state, codePoint, argBuilder);
            } else {
                this.parseUnquotedString(state, argBuilder);
            }
        }
        return argBuilder.toString();
    }

    private void parseQuotedString(TokenizerState state, int startQuotation, StringBuilder builder) throws ArgumentParseException {
        int nextCodePoint = state.next();
        if (nextCodePoint != startQuotation) {
            throw state.createException(String.format("Actual next character '%c' did not match expected quotation character '%c'", nextCodePoint, startQuotation));
        }
        while (state.hasMore()) {
            nextCodePoint = state.peek();
            if (nextCodePoint == startQuotation) {
                state.next();
                return;
            }
            if (nextCodePoint == 92) {
                QuotedStringTokenizer.parseEscape(state, builder);
                continue;
            }
            builder.appendCodePoint(state.next());
        }
        return;
    }

    private void parseUnquotedString(TokenizerState state, StringBuilder builder) throws ArgumentParseException {
        while (state.hasMore()) {
            int nextCodePoint = state.peek();
            if (Character.isWhitespace(nextCodePoint)) {
                return;
            }
            if (nextCodePoint == 92) {
                QuotedStringTokenizer.parseEscape(state, builder);
                continue;
            }
            builder.appendCodePoint(state.next());
        }
    }

    private static void parseEscape(TokenizerState state, StringBuilder builder) throws ArgumentParseException {
        state.next();
        builder.appendCodePoint(state.next());
    }

    private static class TokenizerState {
        private final String buffer;
        private int index = -1;

        TokenizerState(String buffer) {
            this.buffer = buffer;
        }

        public boolean hasMore() {
            return this.index + 1 < this.buffer.length();
        }

        public int peek() throws ArgumentParseException {
            if (!this.hasMore()) {
                throw this.createException("Buffer overrun while parsing args");
            }
            return this.buffer.codePointAt(this.index + 1);
        }

        public int next() throws ArgumentParseException {
            if (!this.hasMore()) {
                throw this.createException("Buffer overrun while parsing args");
            }
            return this.buffer.codePointAt(++this.index);
        }

        public ArgumentParseException createException(String message2) {
            return new ArgumentParseException(message2, this.buffer, this.index);
        }

        public int getIndex() {
            return this.index;
        }
    }
}

