/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.util;

import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.annotation.Flag;
import revxrsal.commands.annotation.Named;
import revxrsal.commands.annotation.Switch;
import revxrsal.commands.util.Preconditions;

public final class Strings {
    public static final Pattern SPACE = Pattern.compile(" ", 16);
    public static final Pattern VERTICAL_BAR = Pattern.compile("|", 16);
    public static final Pattern SNOWFLAKE = Pattern.compile("<(@!|@|@&|#)(?<snowflake>\\d{18})>");

    private Strings() {
    }

    public static LinkedList<String> splitBySpace(String text) {
        String[] result2 = SPACE.split(text);
        LinkedList<String> list = new LinkedList<String>();
        Collections.addAll(list, result2);
        return list;
    }

    @Nullable
    public static String getSnowflake(String mention) {
        Matcher matcher = SNOWFLAKE.matcher(mention);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    public static String getName(@NotNull Parameter parameter) {
        Named named = parameter.getAnnotation(Named.class);
        if (named != null) {
            return named.value();
        }
        Switch switchAnn = parameter.getAnnotation(Switch.class);
        if (switchAnn != null) {
            return switchAnn.value().isEmpty() ? parameter.getName() : switchAnn.value();
        }
        Flag flag = parameter.getAnnotation(Flag.class);
        if (flag != null) {
            return flag.value().isEmpty() ? parameter.getName() : flag.value();
        }
        return parameter.getName();
    }

    public static String repeat(String string2, int count2) {
        int n;
        Preconditions.notNull(string2, "string");
        if (count2 <= 1) {
            Preconditions.checkArgument(count2 >= 0, "invalid count: " + count2);
            return count2 == 0 ? "" : string2;
        }
        int len = string2.length();
        long longSize = (long)len * (long)count2;
        int size2 = (int)longSize;
        if ((long)size2 != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] array = new char[size2];
        string2.getChars(0, len, array, 0);
        for (n = len; n < size2 - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size2 - n);
        return new String(array);
    }

    public static String colorize(@NotNull String text) {
        char[] b = text.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }
}

