/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.util;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.util.Primitives;

public final class ClassMap<V>
extends HashMap<Class<?>, V> {
    public boolean add(Class<?> type, V value2) {
        Class<?> wrapped = Primitives.wrap(type);
        if (this.containsKey(wrapped)) {
            return false;
        }
        this.put(wrapped, value2);
        return false;
    }

    public V getFlexibleOrDefault(@NotNull Class<?> key, V def) {
        V value2 = this.getFlexible(key);
        if (value2 == null) {
            return def;
        }
        return value2;
    }

    public V getFlexible(@NotNull Class<?> key) {
        Object v = this.get(key = Primitives.wrap(key));
        if (v != null) {
            return v;
        }
        for (Map.Entry entry : this.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(key)) continue;
            v = entry.getValue();
            break;
        }
        this.put(key, v);
        return v;
    }
}

