/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.exception;

import java.text.NumberFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.exception.ArgumentParseException;
import revxrsal.commands.exception.CommandExceptionAdapter;
import revxrsal.commands.exception.CommandInvocationException;
import revxrsal.commands.exception.CooldownException;
import revxrsal.commands.exception.EnumNotFoundException;
import revxrsal.commands.exception.InvalidBooleanException;
import revxrsal.commands.exception.InvalidCommandException;
import revxrsal.commands.exception.InvalidHelpPageException;
import revxrsal.commands.exception.InvalidNumberException;
import revxrsal.commands.exception.InvalidSubcommandException;
import revxrsal.commands.exception.InvalidURLException;
import revxrsal.commands.exception.InvalidUUIDException;
import revxrsal.commands.exception.MissingArgumentException;
import revxrsal.commands.exception.NoPermissionException;
import revxrsal.commands.exception.NoSubcommandSpecifiedException;
import revxrsal.commands.exception.NumberNotInRangeException;
import revxrsal.commands.exception.SendableException;
import revxrsal.commands.exception.TooManyArgumentsException;

public class DefaultExceptionHandler
extends CommandExceptionAdapter {
    public static final DefaultExceptionHandler INSTANCE = new DefaultExceptionHandler();
    public static final NumberFormat FORMAT = NumberFormat.getInstance();

    @Override
    public void missingArgument(@NotNull CommandActor actor, @NotNull MissingArgumentException exception) {
        actor.errorLocalized("missing-argument", exception.getParameter().getName());
    }

    @Override
    public void invalidEnumValue(@NotNull CommandActor actor, @NotNull EnumNotFoundException exception) {
        actor.errorLocalized("invalid-enum", exception.getParameter().getName(), exception.getInput());
    }

    @Override
    public void invalidNumber(@NotNull CommandActor actor, @NotNull InvalidNumberException exception) {
        actor.errorLocalized("invalid-number", exception.getInput());
    }

    @Override
    public void invalidUUID(@NotNull CommandActor actor, @NotNull InvalidUUIDException exception) {
        actor.errorLocalized("invalid-uuid", exception.getInput());
    }

    @Override
    public void invalidURL(@NotNull CommandActor actor, @NotNull InvalidURLException exception) {
        actor.errorLocalized("invalid-url", exception.getInput());
    }

    @Override
    public void invalidBoolean(@NotNull CommandActor actor, @NotNull InvalidBooleanException exception) {
        actor.errorLocalized("invalid-boolean", exception.getInput());
    }

    @Override
    public void noPermission(@NotNull CommandActor actor, @NotNull NoPermissionException exception) {
        actor.errorLocalized("no-permission", new Object[0]);
    }

    @Override
    public void argumentParse(@NotNull CommandActor actor, @NotNull ArgumentParseException exception) {
        actor.errorLocalized("invalid-quoted-string", new Object[0]);
        actor.error(exception.getSourceString());
        actor.error(exception.getAnnotatedPosition());
    }

    @Override
    public void commandInvocation(@NotNull CommandActor actor, @NotNull CommandInvocationException exception) {
        actor.errorLocalized("error-occurred", new Object[0]);
        exception.getCause().printStackTrace();
    }

    @Override
    public void tooManyArguments(@NotNull CommandActor actor, @NotNull TooManyArgumentsException exception) {
        ExecutableCommand command2 = exception.getCommand();
        String usage = (command2.getPath().toRealString() + " " + command2.getUsage()).trim();
        actor.errorLocalized("too-many-arguments", usage);
    }

    @Override
    public void invalidCommand(@NotNull CommandActor actor, @NotNull InvalidCommandException exception) {
        actor.errorLocalized("invalid-command", exception.getInput());
    }

    @Override
    public void invalidSubcommand(@NotNull CommandActor actor, @NotNull InvalidSubcommandException exception) {
        actor.errorLocalized("invalid-subcommand", exception.getInput());
    }

    @Override
    public void noSubcommandSpecified(@NotNull CommandActor actor, @NotNull NoSubcommandSpecifiedException exception) {
        actor.errorLocalized("no-subcommand-specified", new Object[0]);
    }

    @Override
    public void cooldown(@NotNull CommandActor actor, @NotNull CooldownException exception) {
        actor.errorLocalized("on-cooldown", DefaultExceptionHandler.formatTimeFancy(exception.getTimeLeftMillis()));
    }

    @Override
    public void invalidHelpPage(@NotNull CommandActor actor, @NotNull InvalidHelpPageException exception) {
        actor.errorLocalized("invalid-help-page", exception.getPage(), exception.getPageCount());
    }

    @Override
    public void sendableException(@NotNull CommandActor actor, @NotNull SendableException exception) {
        exception.sendTo(actor);
    }

    @Override
    public void numberNotInRange(@NotNull CommandActor actor, @NotNull NumberNotInRangeException exception) {
        actor.errorLocalized("number-not-in-range", exception.getParameter().getName(), FORMAT.format(exception.getMinimum()), FORMAT.format(exception.getMaximum()), FORMAT.format(exception.getInput()));
    }

    @Override
    public void onUnhandledException(@NotNull CommandActor actor, @NotNull Throwable throwable) {
        throwable.printStackTrace();
    }

    public static String formatTimeFancy(long time) {
        Duration d = Duration.ofMillis(time);
        long hours = d.toHours();
        long minutes = d.minusHours(hours).getSeconds() / 60L;
        long seconds = d.minusMinutes(minutes).minusHours(hours).getSeconds();
        ArrayList<String> words = new ArrayList<String>();
        if (hours != 0L) {
            words.add(hours + DefaultExceptionHandler.plural(hours, " hour"));
        }
        if (minutes != 0L) {
            words.add(minutes + DefaultExceptionHandler.plural(minutes, " minute"));
        }
        if (seconds != 0L) {
            words.add(seconds + DefaultExceptionHandler.plural(seconds, " second"));
        }
        return DefaultExceptionHandler.toFancyString(words);
    }

    public static <T> String toFancyString(List<T> list) {
        StringJoiner builder = new StringJoiner(", ");
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0).toString();
        }
        for (int i = 0; i < list.size(); ++i) {
            T el = list.get(i);
            if (i + 1 == list.size()) {
                return builder + " and " + el.toString();
            }
            builder.add(el.toString());
        }
        return builder.toString();
    }

    public static String plural(Number count2, String thing) {
        if (count2.intValue() == 1) {
            return thing;
        }
        if (thing.endsWith("y")) {
            return thing.substring(0, thing.length() - 1) + "ies";
        }
        return thing + "s";
    }
}

