/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.exception;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.core.reflect.MethodCaller;
import revxrsal.commands.core.reflect.MethodCallerFactory;
import revxrsal.commands.exception.ArgumentParseException;
import revxrsal.commands.exception.CommandExceptionHandler;
import revxrsal.commands.exception.CommandInvocationException;
import revxrsal.commands.exception.CooldownException;
import revxrsal.commands.exception.EnumNotFoundException;
import revxrsal.commands.exception.InvalidBooleanException;
import revxrsal.commands.exception.InvalidCommandException;
import revxrsal.commands.exception.InvalidHelpPageException;
import revxrsal.commands.exception.InvalidNumberException;
import revxrsal.commands.exception.InvalidSubcommandException;
import revxrsal.commands.exception.InvalidURLException;
import revxrsal.commands.exception.InvalidUUIDException;
import revxrsal.commands.exception.MissingArgumentException;
import revxrsal.commands.exception.NoPermissionException;
import revxrsal.commands.exception.NoSubcommandSpecifiedException;
import revxrsal.commands.exception.NumberNotInRangeException;
import revxrsal.commands.exception.SelfHandledException;
import revxrsal.commands.exception.SendableException;
import revxrsal.commands.exception.TooManyArgumentsException;
import revxrsal.commands.util.ClassMap;

public abstract class CommandExceptionAdapter
implements CommandExceptionHandler {
    private static final List<Method> IGNORED_METHODS = new ArrayList<Method>();
    private final ClassMap<MethodExceptionHandler> handlers = new ClassMap();
    private final MethodExceptionHandler unknownHandler = this::onUnhandledException;

    @Ignore
    public void onUnhandledException(@NotNull CommandActor actor, @NotNull Throwable throwable) {
    }

    public void missingArgument(@NotNull CommandActor actor, @NotNull MissingArgumentException exception) {
    }

    public void invalidEnumValue(@NotNull CommandActor actor, @NotNull EnumNotFoundException exception) {
    }

    public void invalidUUID(@NotNull CommandActor actor, @NotNull InvalidUUIDException exception) {
    }

    public void invalidNumber(@NotNull CommandActor actor, @NotNull InvalidNumberException exception) {
    }

    public void invalidURL(@NotNull CommandActor actor, @NotNull InvalidURLException exception) {
    }

    public void invalidBoolean(@NotNull CommandActor actor, @NotNull InvalidBooleanException exception) {
    }

    public void numberNotInRange(@NotNull CommandActor actor, @NotNull NumberNotInRangeException exception) {
    }

    public void noPermission(@NotNull CommandActor actor, @NotNull NoPermissionException exception) {
    }

    public void argumentParse(@NotNull CommandActor actor, @NotNull ArgumentParseException exception) {
    }

    public void commandInvocation(@NotNull CommandActor actor, @NotNull CommandInvocationException exception) {
    }

    public void tooManyArguments(@NotNull CommandActor actor, @NotNull TooManyArgumentsException exception) {
    }

    public void invalidCommand(@NotNull CommandActor actor, @NotNull InvalidCommandException exception) {
    }

    public void invalidSubcommand(@NotNull CommandActor actor, @NotNull InvalidSubcommandException exception) {
    }

    public void noSubcommandSpecified(@NotNull CommandActor actor, @NotNull NoSubcommandSpecifiedException exception) {
    }

    public void cooldown(@NotNull CommandActor actor, @NotNull CooldownException exception) {
    }

    public void invalidHelpPage(@NotNull CommandActor actor, @NotNull InvalidHelpPageException exception) {
    }

    public void sendableException(@NotNull CommandActor actor, @NotNull SendableException exception) {
    }

    @Override
    @Ignore
    public void handleException(@NotNull Throwable throwable, @NotNull CommandActor actor) {
        MethodExceptionHandler handler2 = this.handlers.getFlexibleOrDefault(throwable.getClass(), this.unknownHandler);
        if (handler2 == this.unknownHandler && throwable instanceof SelfHandledException) {
            ((SelfHandledException)((Object)throwable)).handle(actor);
        } else {
            handler2.handle(actor, throwable);
        }
    }

    public CommandExceptionAdapter() {
        for (Method m : this.getClass().getMethods()) {
            this.register(m);
        }
    }

    private void register(@NotNull Method method) {
        MethodExceptionHandler handler2;
        Class<?> exceptionType;
        if (!CommandExceptionAdapter.class.isAssignableFrom(method.getDeclaringClass())) {
            return;
        }
        if (method.getParameterCount() != 2) {
            return;
        }
        if (method.isAnnotationPresent(Ignore.class)) {
            return;
        }
        for (Method ignoredMethod : IGNORED_METHODS) {
            if (!method.getName().equals(ignoredMethod.getName()) || !Arrays.equals(method.getParameterTypes(), ignoredMethod.getParameterTypes())) continue;
            return;
        }
        Parameter[] parameters2 = method.getParameters();
        Class<?> firstType = parameters2[0].getType();
        Class<?> secondType = parameters2[1].getType();
        if (CommandActor.class.isAssignableFrom(firstType) && Throwable.class.isAssignableFrom(secondType)) {
            exceptionType = secondType;
            MethodCaller.BoundMethodCaller caller = MethodCallerFactory.defaultFactory().createFor(method).bindTo(this);
            handler2 = (xva$0, xva$1) -> caller.call(xva$0, xva$1);
        } else if (Throwable.class.isAssignableFrom(firstType) && CommandActor.class.isAssignableFrom(secondType)) {
            exceptionType = firstType;
            MethodCaller.BoundMethodCaller caller = MethodCallerFactory.defaultFactory().createFor(method).bindTo(this);
            handler2 = (actor, throwable) -> caller.call(throwable, actor);
        } else {
            return;
        }
        this.handlers.add(exceptionType, handler2);
    }

    static {
        for (Method method : CommandExceptionAdapter.class.getDeclaredMethods()) {
            if (method.getParameterCount() != 2 || !method.isAnnotationPresent(Ignore.class)) continue;
            IGNORED_METHODS.add(method);
        }
    }

    private static interface MethodExceptionHandler {
        public void handle(@NotNull CommandActor var1, @NotNull Throwable var2);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Ignore {
    }
}

