/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.core.reflect.MethodCaller;
import revxrsal.commands.core.reflect.MethodCallerFactory;

final class MethodHandlesCallerFactory
implements MethodCallerFactory {
    public static final MethodHandlesCallerFactory INSTANCE = new MethodHandlesCallerFactory();

    MethodHandlesCallerFactory() {
    }

    @Override
    @NotNull
    public MethodCaller createFor(@NotNull Method method) throws Throwable {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        final MethodHandle handle2 = MethodHandles.lookup().unreflect(method);
        final String methodString = method.toString();
        final boolean isStatic = Modifier.isStatic(method.getModifiers());
        return new MethodCaller(){

            @Override
            public Object call(@Nullable Object instance, Object ... arguments) {
                if (!isStatic) {
                    ArrayList<Object> args2 = new ArrayList<Object>();
                    args2.add(instance);
                    Collections.addAll(args2, arguments);
                    return handle2.invokeWithArguments(args2);
                }
                return handle2.invokeWithArguments(arguments);
            }

            public String toString() {
                return "MethodHandlesCaller(" + methodString + ")";
            }
        };
    }

    public String toString() {
        return "MethodHandlesCallerFactory";
    }
}

