/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.annotation.NotSender;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.process.ContextResolver;
import revxrsal.commands.process.ContextResolverFactory;
import revxrsal.commands.process.SenderResolver;
import revxrsal.commands.util.Preconditions;

final class SenderContextResolverFactory
implements ContextResolverFactory {
    private static final SenderResolver SELF = new SenderResolver(){

        @Override
        public boolean isCustomType(Class<?> type) {
            return CommandActor.class.isAssignableFrom(type);
        }

        @Override
        @NotNull
        public Object getSender(@NotNull Class<?> customSenderType, @NotNull CommandActor actor, @NotNull ExecutableCommand command2) {
            return actor;
        }
    };
    private final List<SenderResolver> resolvers;

    public SenderContextResolverFactory(List<SenderResolver> resolvers) {
        this.resolvers = resolvers;
        resolvers.add(SELF);
    }

    @Override
    @Nullable
    public ContextResolver<?> create(@NotNull CommandParameter parameter) {
        if (parameter.getMethodIndex() != 0) {
            return null;
        }
        if (parameter.hasAnnotation(NotSender.class)) {
            return null;
        }
        for (SenderResolver resolver : this.resolvers) {
            if (!resolver.isCustomType(parameter.getType())) continue;
            return context -> Preconditions.notNull(resolver.getSender(parameter.getType(), (CommandActor)context.actor(), context.command()), "SenderResolver#getSender() must not return null!");
        }
        return null;
    }
}

