/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.annotation.CaseSensitive;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.exception.EnumNotFoundException;
import revxrsal.commands.process.ValueResolver;
import revxrsal.commands.process.ValueResolverFactory;

enum EnumResolverFactory implements ValueResolverFactory
{
    INSTANCE;


    @Override
    @Nullable
    public ValueResolver<?> create(@NotNull CommandParameter parameter) {
        Class<?> type = parameter.getType();
        if (!type.isEnum()) {
            return null;
        }
        Class<Enum> enumType = type.asSubclass(Enum.class);
        HashMap<String, Enum> values2 = new HashMap<String, Enum>();
        boolean caseSensitive = parameter.hasAnnotation(CaseSensitive.class);
        for (Enum enumConstant : enumType.getEnumConstants()) {
            if (caseSensitive) {
                values2.put(enumConstant.name(), enumConstant);
                continue;
            }
            values2.put(enumConstant.name().toLowerCase(), enumConstant);
        }
        return context -> {
            String value2 = context.pop();
            Enum v = (Enum)values2.get(caseSensitive ? value2 : value2.toLowerCase());
            if (v == null) {
                throw new EnumNotFoundException(parameter, value2);
            }
            return v;
        };
    }
}

