/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.CommandHandler;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Default;
import revxrsal.commands.annotation.Description;
import revxrsal.commands.annotation.Flag;
import revxrsal.commands.annotation.SecretCommand;
import revxrsal.commands.annotation.Single;
import revxrsal.commands.annotation.Subcommand;
import revxrsal.commands.annotation.Switch;
import revxrsal.commands.annotation.Usage;
import revxrsal.commands.command.ArgumentStack;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.command.CommandPermission;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.core.AnnotationReader;
import revxrsal.commands.core.BaseCommandCategory;
import revxrsal.commands.core.BaseCommandHandler;
import revxrsal.commands.core.BaseCommandParameter;
import revxrsal.commands.core.CommandExecutable;
import revxrsal.commands.core.CommandPath;
import revxrsal.commands.core.CompletionStageResponseHandler;
import revxrsal.commands.core.OptionalResponseHandler;
import revxrsal.commands.core.Resolver;
import revxrsal.commands.core.SupplierResponseHandler;
import revxrsal.commands.core.reflect.MethodCaller;
import revxrsal.commands.orphan.OrphanCommand;
import revxrsal.commands.orphan.OrphanRegistry;
import revxrsal.commands.process.PermissionReader;
import revxrsal.commands.process.ResponseHandler;
import revxrsal.commands.util.Collections;
import revxrsal.commands.util.Preconditions;
import revxrsal.commands.util.Primitives;
import revxrsal.commands.util.Strings;

final class CommandParser {
    static final ResponseHandler<?> VOID_HANDLER = (response2, actor, command2) -> {};
    private static final AtomicInteger COMMAND_ID = new AtomicInteger();

    private CommandParser() {
    }

    public static void parse(@NotNull BaseCommandHandler handler2, @NotNull OrphanRegistry orphan) {
        OrphanCommand instance = orphan.getHandler();
        Class<?> type = instance.getClass();
        CommandParser.parse(handler2, type, orphan);
    }

    public static void parse(@NotNull BaseCommandHandler handler2, @NotNull Object boundTarget) {
        Class<?> type = boundTarget instanceof Class ? (Class<?>)boundTarget : boundTarget.getClass();
        CommandParser.parse(handler2, type, boundTarget);
    }

    public static void parse(@NotNull BaseCommandHandler handler2, @NotNull Class<?> container, @NotNull Object boundTarget) {
        Map<CommandPath, BaseCommandCategory> categories = handler2.categories;
        HashMap<CommandPath, CommandExecutable> subactions = new HashMap<CommandPath, CommandExecutable>();
        for (Method method : CommandParser.getAllMethods(container)) {
            AnnotationReader reader = AnnotationReader.create(handler2, method);
            Object invokeTarget = boundTarget;
            if (reader.shouldDismiss()) continue;
            if (boundTarget instanceof OrphanRegistry) {
                CommandParser.insertCommandPath((OrphanRegistry)boundTarget, reader);
                invokeTarget = ((OrphanRegistry)invokeTarget).getHandler();
            }
            reader.distributeAnnotations();
            reader.replaceAnnotations(handler2);
            List<CommandPath> paths = CommandParser.getCommandPath(container, method, reader);
            MethodCaller.BoundMethodCaller caller = handler2.getMethodCallerFactory().createFor(method).bindTo(invokeTarget);
            int id = COMMAND_ID.getAndIncrement();
            boolean isDefault = reader.contains(Default.class);
            paths.forEach(path -> {
                for (BaseCommandCategory category : CommandParser.getCategories(handler2, isDefault, path)) {
                    categories.putIfAbsent(category.path, category);
                }
                CommandExecutable executable = new CommandExecutable();
                if (!isDefault) {
                    categories.remove(path);
                }
                executable.name = path.getLast();
                executable.id = id;
                executable.handler = handler2;
                executable.description = reader.get(Description.class, Description::value);
                executable.path = path;
                executable.method = method;
                executable.reader = reader;
                executable.secret = reader.contains(SecretCommand.class);
                executable.methodCaller = caller;
                if (isDefault) {
                    executable.parent((BaseCommandCategory)categories.get(path));
                } else {
                    executable.parent((BaseCommandCategory)categories.get(path.getCategoryPath()));
                }
                executable.responseHandler = CommandParser.getResponseHandler(handler2, method.getGenericReturnType());
                executable.parameters = CommandParser.getParameters(handler2, method, executable);
                executable.resolveableParameters = executable.parameters.stream().filter(c -> c.getCommandIndex() != -1).collect(Collectors.toMap(CommandParameter::getCommandIndex, c -> c));
                executable.usage = reader.get(Usage.class, Usage::value, () -> CommandParser.generateUsage(executable));
                if (reader.contains(Default.class)) {
                    subactions.put((CommandPath)path, executable);
                } else {
                    CommandParser.putOrError(handler2.executables, path, executable, "A command with path '" + path.toRealString() + "' already exists!");
                }
            });
        }
        subactions.forEach((path, subaction) -> {
            BaseCommandCategory cat = (BaseCommandCategory)categories.get(path);
            if (cat != null) {
                cat.defaultAction = subaction;
            }
        });
    }

    private static void insertCommandPath(OrphanRegistry boundTarget, AnnotationReader reader) {
        List<CommandPath> paths = boundTarget.getParentPaths();
        final String[] pathsArray = (String[])paths.stream().map(CommandPath::toRealString).toArray(String[]::new);
        reader.add(new Command(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Command.class;
            }

            @Override
            public String[] value() {
                return pathsArray;
            }
        });
    }

    private static Set<Method> getAllMethods(Class<?> c) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> current = c; current != null && current != Object.class; current = current.getSuperclass()) {
            java.util.Collections.addAll(methods, current.getDeclaredMethods());
        }
        return methods;
    }

    private static String generateUsage(@NotNull ExecutableCommand command2) {
        StringJoiner joiner = new StringJoiner(" ");
        CommandHandler handler2 = command2.getCommandHandler();
        for (CommandParameter parameter : command2.getValueParameters().values()) {
            if (!parameter.getResolver().mutatesArguments()) continue;
            if (parameter.isSwitch()) {
                joiner.add("[" + handler2.getSwitchPrefix() + parameter.getSwitchName() + "]");
                continue;
            }
            if (parameter.isFlag()) {
                joiner.add("[" + handler2.getFlagPrefix() + parameter.getFlagName() + " <value>]");
                continue;
            }
            if (parameter.isOptional()) {
                joiner.add("[" + parameter.getName() + "]");
                continue;
            }
            joiner.add("<" + parameter.getName() + ">");
        }
        return joiner.toString();
    }

    private static ResponseHandler<?> getResponseHandler(BaseCommandHandler handler2, Type genericType) {
        Class<?> rawType = Primitives.getRawType(genericType);
        if (CompletionStage.class.isAssignableFrom(rawType)) {
            ResponseHandler<Object> delegateHandler = CommandParser.getResponseHandler(handler2, CommandParser.getInsideGeneric(genericType));
            return new CompletionStageResponseHandler(handler2, delegateHandler);
        }
        if (Optional.class.isAssignableFrom(rawType)) {
            ResponseHandler<Object> delegateHandler = CommandParser.getResponseHandler(handler2, CommandParser.getInsideGeneric(genericType));
            return new OptionalResponseHandler(delegateHandler);
        }
        if (Supplier.class.isAssignableFrom(rawType)) {
            ResponseHandler<Object> delegateHandler = CommandParser.getResponseHandler(handler2, CommandParser.getInsideGeneric(genericType));
            return new SupplierResponseHandler(delegateHandler);
        }
        return handler2.responseHandlers.getFlexibleOrDefault(rawType, VOID_HANDLER);
    }

    private static Type getInsideGeneric(Type genericType) {
        try {
            return ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        catch (ClassCastException e) {
            return Object.class;
        }
    }

    private static Set<BaseCommandCategory> getCategories(CommandHandler handler2, boolean respectDefault, @NotNull CommandPath path) {
        if (path.size() == 1 && !respectDefault) {
            return java.util.Collections.emptySet();
        }
        String parent = path.getParent();
        HashSet<BaseCommandCategory> categories = new HashSet<BaseCommandCategory>();
        BaseCommandCategory root = new BaseCommandCategory();
        root.handler = handler2;
        root.path = CommandPath.get(parent);
        root.name = parent;
        categories.add(root);
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(parent);
        for (String subcommand : path.getSubcommandPath()) {
            pathList.add(subcommand);
            BaseCommandCategory cat = new BaseCommandCategory();
            cat.handler = handler2;
            cat.path = CommandPath.get(pathList);
            cat.name = cat.path.getName();
            categories.add(cat);
        }
        return categories;
    }

    private static List<CommandParameter> getParameters(@NotNull BaseCommandHandler handler2, @NotNull Method method, @NotNull CommandExecutable parent) {
        ArrayList<BaseCommandParameter> parameters2 = new ArrayList<BaseCommandParameter>();
        Parameter[] methodParameters = method.getParameters();
        int cIndex = 0;
        for (int i = 0; i < methodParameters.length; ++i) {
            Parameter parameter = methodParameters[i];
            AnnotationReader paramAnns = AnnotationReader.create(handler2, parameter);
            ArrayList validators = new ArrayList(handler2.validators.getFlexibleOrDefault(parameter.getType(), java.util.Collections.emptyList()));
            String[] defaultValue = paramAnns.get(Default.class, Default::value);
            BaseCommandParameter param = new BaseCommandParameter(Strings.getName(parameter), paramAnns.get(Description.class, Description::value), i, defaultValue == null ? java.util.Collections.emptyList() : java.util.Collections.unmodifiableList(Arrays.asList(defaultValue)), i == methodParameters.length - 1 && !paramAnns.contains(Single.class), paramAnns.contains(revxrsal.commands.annotation.Optional.class) || paramAnns.contains(Default.class), parent, parameter, paramAnns.get(Switch.class), paramAnns.get(Flag.class), java.util.Collections.unmodifiableList(validators));
            for (PermissionReader reader : handler2.getPermissionReaders()) {
                CommandPermission permission = reader.getPermission(param);
                if (permission == null) continue;
                param.permission = permission;
                break;
            }
            if (param.getType().isPrimitive() && param.isOptional() && param.getDefaultValue().isEmpty() && !param.isSwitch()) {
                throw new IllegalStateException("Optional parameter " + parameter + " at " + method + " cannot be a prmitive!");
            }
            if (param.isSwitch() && Primitives.wrap(param.getType()) != Boolean.class) {
                throw new IllegalStateException("Switch parameter " + parameter + " at " + method + " must be of boolean type!");
            }
            Resolver resolver = param.getType() == ArgumentStack.class ? new Resolver(context -> ArgumentStack.copy(context.input()), null) : handler2.getResolver(param);
            if (resolver == null) {
                throw new IllegalStateException("Unable to find a resolver for parameter type " + parameter.getType());
            }
            param.resolver = resolver;
            if (resolver.mutatesArguments()) {
                param.cindex = cIndex++;
            }
            param.suggestionProvider = handler2.autoCompleter.getProvider(param);
            parameters2.add(param);
        }
        return java.util.Collections.unmodifiableList(parameters2);
    }

    private static List<CommandPath> getCommandPath(@NotNull Class<?> container, @NotNull Method method, @NotNull AnnotationReader reader) {
        ArrayList<CommandPath> paths = new ArrayList<CommandPath>();
        ArrayList commands = new ArrayList();
        ArrayList subcommands = new ArrayList();
        Command commandAnnotation = reader.get(Command.class, "Method " + method.getName() + " does not have a parent command! You might have forgotten one of the following:\n- @Command on the method or class\n- implement OrphanCommand");
        Preconditions.notEmpty(commandAnnotation.value(), "@Command#value() cannot be an empty array!");
        java.util.Collections.addAll(commands, commandAnnotation.value());
        ArrayList parentSubcommandAliases = new ArrayList();
        for (Class<?> topClass : CommandParser.getTopClasses(container)) {
            Subcommand ps = topClass.getAnnotation(Subcommand.class);
            if (ps == null) continue;
            java.util.Collections.addAll(parentSubcommandAliases, ps.value());
        }
        Subcommand subcommandAnnotation = reader.get(Subcommand.class);
        if (subcommandAnnotation != null) {
            java.util.Collections.addAll(subcommands, subcommandAnnotation.value());
        }
        for (String command2 : commands) {
            if (!subcommands.isEmpty()) {
                for (String subcommand : subcommands) {
                    ArrayList<String> path = new ArrayList<String>(Strings.splitBySpace(command2));
                    parentSubcommandAliases.forEach(subcommandAlias -> path.addAll(Strings.splitBySpace(subcommandAlias)));
                    path.addAll(Strings.splitBySpace(subcommand));
                    paths.add(CommandPath.get(path));
                }
                continue;
            }
            paths.add(CommandPath.get(Strings.splitBySpace(command2)));
        }
        return paths;
    }

    private static List<Class<?>> getTopClasses(Class<?> c) {
        List<Class<?>> classes = Collections.listOf(c);
        Class<?> enclosingClass = c.getEnclosingClass();
        while (c.getEnclosingClass() != null) {
            c = enclosingClass;
            classes.add(c);
        }
        java.util.Collections.reverse(classes);
        return classes;
    }

    private static <K, V> void putOrError(Map<K, V> map2, K key, V value2, String err) {
        if (map2.containsKey(key)) {
            throw new IllegalStateException(err);
        }
        map2.put(key, value2);
    }
}

