/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import revxrsal.commands.CommandHandler;
import revxrsal.commands.annotation.Default;
import revxrsal.commands.command.CommandCategory;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.command.CommandPermission;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.core.AnnotationReader;
import revxrsal.commands.core.BaseCommandCategory;
import revxrsal.commands.core.CommandParser;
import revxrsal.commands.core.CommandPath;
import revxrsal.commands.core.reflect.MethodCaller;
import revxrsal.commands.process.ResponseHandler;
import revxrsal.commands.util.Preconditions;

class CommandExecutable
implements ExecutableCommand {
    CommandHandler handler;
    boolean permissionSet = false;
    int id;
    CommandPath path;
    String name;
    String usage;
    String description;
    Method method;
    AnnotationReader reader;
    boolean secret;
    MethodCaller.BoundMethodCaller methodCaller;
    BaseCommandCategory parent;
    ResponseHandler responseHandler = CommandParser.VOID_HANDLER;
    private CommandPermission permission = CommandPermission.ALWAYS_TRUE;
    @Unmodifiable List<CommandParameter> parameters;
    @Unmodifiable Map<Integer, CommandParameter> resolveableParameters;

    CommandExecutable() {
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getUsage() {
        return this.usage;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public CommandPath getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public CommandCategory getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public @Unmodifiable List<CommandParameter> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public @Unmodifiable Map<Integer, CommandParameter> getValueParameters() {
        return this.resolveableParameters;
    }

    @Override
    @NotNull
    public CommandPermission getPermission() {
        return this.permission;
    }

    @Override
    @NotNull
    public CommandHandler getCommandHandler() {
        return this.handler;
    }

    @Override
    @NotNull
    public <T> ResponseHandler<T> getResponseHandler() {
        return this.responseHandler;
    }

    @Override
    public boolean isSecret() {
        return this.secret;
    }

    @Override
    public <A extends Annotation> A getAnnotation(@NotNull Class<A> annotation) {
        return this.reader.get(annotation);
    }

    @Override
    public boolean hasAnnotation(@NotNull Class<? extends Annotation> annotation) {
        return this.reader.contains(annotation);
    }

    public void parent(BaseCommandCategory cat) {
        this.parent = cat;
        if (this.hasAnnotation(Default.class) && cat != null) {
            cat.defaultAction = this;
        } else if (cat != null) {
            cat.commands.put(this.path, this);
        }
    }

    public void setPermission(@NotNull CommandPermission permission) {
        Preconditions.notNull(permission, "permission");
        this.permission = permission;
    }

    public String toString() {
        return "ExecutableCommand{path=" + this.path + ", name='" + this.name + '\'' + '}';
    }

    @Override
    public int compareTo(@NotNull ExecutableCommand o) {
        return this.path.compareTo(o.getPath());
    }
}

