/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandCategory;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.core.BaseCommandHandler;
import revxrsal.commands.core.CommandPath;
import revxrsal.commands.exception.InvalidHelpPageException;
import revxrsal.commands.help.CommandHelp;
import revxrsal.commands.help.CommandHelpWriter;
import revxrsal.commands.process.ContextResolver;

final class BaseCommandHelp<T>
extends ArrayList<T>
implements CommandHelp<T> {
    BaseCommandHelp() {
    }

    @Override
    public CommandHelp<T> paginate(int page, int elementsPerPage) throws InvalidHelpPageException {
        if (this.isEmpty()) {
            return new BaseCommandHelp<T>();
        }
        BaseCommandHelp<T> list = new BaseCommandHelp<T>();
        int size2 = this.getPageSize(elementsPerPage);
        if (page > size2) {
            throw new InvalidHelpPageException(this, page, elementsPerPage);
        }
        int listIndex = page - 1;
        int l = Math.min(page * elementsPerPage, this.size());
        for (int i = listIndex * elementsPerPage; i < l; ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    @Override
    public @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) int getPageSize(int elementsPerPage) {
        if (elementsPerPage < 1) {
            throw new IllegalArgumentException("Elements per page cannot be less than 1! (Found " + elementsPerPage + ")");
        }
        return this.size() / elementsPerPage + (this.size() % elementsPerPage == 0 ? 0 : 1);
    }

    static final class Resolver
    implements ContextResolver<CommandHelp<?>> {
        private final BaseCommandHandler handler;

        public Resolver(BaseCommandHandler handler2) {
            this.handler = handler2;
        }

        @Override
        public CommandHelp<?> resolve(@NotNull ContextResolver.ContextResolverContext context) {
            if (this.handler.getHelpWriter() == null) {
                throw new IllegalArgumentException("No help writer is registered!");
            }
            ExecutableCommand helpCommand = context.command();
            CommandHelpWriter writer = this.handler.getHelpWriter();
            BaseCommandHelp entries2 = new BaseCommandHelp();
            CommandCategory parent = helpCommand.getParent();
            CommandPath parentPath = parent == null ? null : parent.getPath();
            this.handler.executables.values().stream().sorted().forEach(c -> {
                Object generated;
                if ((parentPath == null || parentPath.isParentOf(c.getPath())) && c != helpCommand && (generated = writer.generate((ExecutableCommand)c, (CommandActor)context.actor())) != null) {
                    entries2.add(generated);
                }
            });
            return entries2;
        }
    }
}

