/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import revxrsal.commands.CommandHandler;
import revxrsal.commands.command.ArgumentStack;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.core.BaseCommandCategory;
import revxrsal.commands.core.BaseCommandHandler;
import revxrsal.commands.core.CommandExecutable;
import revxrsal.commands.core.MutableCommandPath;
import revxrsal.commands.exception.CommandInvocationException;
import revxrsal.commands.exception.InvalidCommandException;
import revxrsal.commands.exception.InvalidNumberException;
import revxrsal.commands.exception.MissingArgumentException;
import revxrsal.commands.exception.NoSubcommandSpecifiedException;
import revxrsal.commands.exception.TooManyArgumentsException;
import revxrsal.commands.process.ContextResolver;
import revxrsal.commands.process.ParameterResolver;
import revxrsal.commands.process.ParameterValidator;
import revxrsal.commands.process.ValueResolver;

public final class BaseCommandDispatcher {
    private final BaseCommandHandler handler;

    public BaseCommandDispatcher(BaseCommandHandler handler2) {
        this.handler = handler2;
    }

    public Object eval(@NotNull CommandActor actor, @NotNull ArgumentStack arguments) {
        try {
            MutableCommandPath path = MutableCommandPath.empty();
            String argument = (String)arguments.getFirst();
            path.add(argument);
            CommandExecutable executable = this.handler.executables.get(path);
            if (executable != null) {
                arguments.removeFirst();
                return this.execute(executable, actor, arguments);
            }
            BaseCommandCategory category = this.handler.categories.get(path);
            if (category != null) {
                arguments.removeFirst();
                return this.searchCategory(actor, category, path, arguments);
            }
            throw new InvalidCommandException(path, path.getFirst());
        }
        catch (Throwable throwable) {
            this.handler.getExceptionHandler().handleException(throwable, actor);
            return null;
        }
    }

    private Object searchCategory(CommandActor actor, BaseCommandCategory category, MutableCommandPath path, ArgumentStack arguments) {
        CommandExecutable executable;
        if (!arguments.isEmpty()) {
            path.add((String)arguments.getFirst());
        }
        if ((executable = (CommandExecutable)category.commands.get(path)) != null) {
            arguments.removeFirst();
            return this.execute(executable, actor, arguments);
        }
        category.checkPermission(actor);
        BaseCommandCategory found = (BaseCommandCategory)category.getCategories().get(path);
        if (found == null) {
            if (category.defaultAction == null) {
                throw new NoSubcommandSpecifiedException(category);
            }
            return this.execute(category.defaultAction, actor, arguments);
        }
        arguments.removeFirst();
        return this.searchCategory(actor, found, path, arguments);
    }

    private Object execute(@NotNull CommandExecutable executable, @NotNull CommandActor actor, @NotNull ArgumentStack args2) {
        Object result2;
        List<String> input2 = args2.asImmutableCopy();
        this.handler.conditions.forEach(condition -> condition.test(actor, executable, args2.asImmutableView()));
        Object[] methodArguments = this.getMethodArguments(executable, actor, args2, input2);
        if (!args2.isEmpty() && this.handler.failOnExtra) {
            throw new TooManyArgumentsException(executable, args2);
        }
        try {
            result2 = executable.methodCaller.call(methodArguments);
        }
        catch (Throwable throwable) {
            throw new CommandInvocationException(executable, throwable);
        }
        executable.responseHandler.handleResponse(result2, actor, executable);
        return result2;
    }

    private Object[] getMethodArguments(CommandExecutable executable, CommandActor actor, ArgumentStack args2, List<String> input2) {
        Object[] values2 = new Object[executable.parameters.size()];
        for (CommandParameter parameter : executable.parameters) {
            if (ArgumentStack.class.isAssignableFrom(parameter.getType())) {
                values2[parameter.getMethodIndex()] = args2;
                continue;
            }
            if (parameter.isSwitch()) {
                this.handleSwitch(args2, values2, parameter);
                continue;
            }
            if (!parameter.isFlag()) continue;
            this.handleFlag(input2, actor, args2, values2, parameter);
        }
        for (CommandParameter parameter : executable.parameters) {
            Object value2;
            ParamResolverContext cxt;
            if (ArgumentStack.class.isAssignableFrom(parameter.getType())) {
                values2[parameter.getMethodIndex()] = args2;
                continue;
            }
            if (parameter.isSwitch() || parameter.isFlag()) continue;
            ParameterResolver resolver = parameter.getResolver();
            if (!resolver.mutatesArguments()) {
                parameter.checkPermission(actor);
                cxt = new ContextResolverContext(input2, actor, parameter, values2);
                value2 = resolver.resolve(cxt);
                for (ParameterValidator<Object> v : parameter.getValidators()) {
                    v.validate(value2, parameter, actor);
                }
                values2[parameter.getMethodIndex()] = value2;
                continue;
            }
            if (this.addDefaultValues(args2, parameter, actor, values2)) continue;
            parameter.checkPermission(actor);
            cxt = new ValueContextR(input2, actor, parameter, values2, args2);
            value2 = resolver.resolve(cxt);
            for (ParameterValidator<Object> v : parameter.getValidators()) {
                v.validate(value2, parameter, actor);
            }
            values2[parameter.getMethodIndex()] = value2;
        }
        return values2;
    }

    private boolean addDefaultValues(ArgumentStack args2, CommandParameter parameter, CommandActor actor, Object[] values2) {
        if (args2.isEmpty()) {
            if (parameter.getDefaultValue().isEmpty() && parameter.isOptional()) {
                values2[parameter.getMethodIndex()] = null;
                return true;
            }
            if (!parameter.getDefaultValue().isEmpty()) {
                args2.addAll(parameter.getDefaultValue());
                return false;
            }
            throw new MissingArgumentException(parameter);
        }
        return false;
    }

    private void handleSwitch(ArgumentStack args2, Object[] values2, CommandParameter parameter) {
        boolean provided = args2.remove(this.handler.switchPrefix + parameter.getSwitchName());
        values2[parameter.getMethodIndex()] = !provided ? Boolean.valueOf(parameter.getDefaultSwitch()) : Boolean.valueOf(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleFlag(List<String> input2, CommandActor actor, ArgumentStack args2, Object[] values2, CommandParameter parameter) {
        ArgumentStack flagArguments;
        block10: {
            String lookup2 = this.handler.getFlagPrefix() + parameter.getFlagName();
            int index = args2.indexOf(lookup2);
            if (index == -1) {
                if (!parameter.isOptional()) throw new MissingArgumentException(parameter);
                if (!parameter.getDefaultValue().isEmpty()) {
                    args2.add(lookup2);
                    args2.addAll(parameter.getDefaultValue());
                    index = args2.indexOf(lookup2);
                    args2.remove(index);
                    flagArguments = this.handler.parseArguments((String)args2.remove(index));
                    break block10;
                } else {
                    Iterator<ParameterValidator<Object>> iterator2 = parameter.getValidators().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            values2[parameter.getMethodIndex()] = null;
                            return;
                        }
                        ParameterValidator<Object> v = iterator2.next();
                        v.validate(null, parameter, actor);
                    }
                }
            }
            args2.remove(index);
            if (index >= args2.size()) {
                throw new MissingArgumentException(parameter);
            }
            flagArguments = this.handler.parseArguments((String)args2.remove(index));
        }
        ValueContextR contextR = new ValueContextR(input2, actor, parameter, values2, flagArguments);
        Object value2 = parameter.getResolver().resolve(contextR);
        Iterator<ParameterValidator<Object>> iterator3 = parameter.getValidators().iterator();
        while (true) {
            if (!iterator3.hasNext()) {
                values2[parameter.getMethodIndex()] = value2;
                return;
            }
            ParameterValidator<Object> v = iterator3.next();
            v.validate(value2, parameter, actor);
        }
    }

    private static final class ValueContextR
    extends ParamResolverContext
    implements ValueResolver.ValueResolverContext {
        private final ArgumentStack argumentStack;

        public ValueContextR(List<String> input2, CommandActor actor, CommandParameter parameter, Object[] resolved, ArgumentStack argumentStack) {
            super(input2, actor, parameter, resolved);
            this.argumentStack = argumentStack;
        }

        @Override
        public ArgumentStack arguments() {
            return this.argumentStack;
        }

        @Override
        public String popForParameter() {
            return this.argumentStack.popForParameter(this.parameter());
        }

        @Override
        public String pop() {
            return (String)this.argumentStack.pop();
        }

        private <T> T num(Function<String, T> f) {
            String input2 = this.pop();
            try {
                if (input2.startsWith("0x")) {
                    return (T)Integer.valueOf(input2.substring(2), 16);
                }
                return f.apply(input2);
            }
            catch (NumberFormatException e) {
                throw new InvalidNumberException(this.parameter(), input2);
            }
        }

        @Override
        public int popInt() {
            return this.num(Integer::parseInt);
        }

        @Override
        public double popDouble() {
            return this.num(Double::parseDouble);
        }

        @Override
        public byte popByte() {
            return this.num(Byte::parseByte);
        }

        @Override
        public short popShort() {
            return this.num(Short::parseShort);
        }

        @Override
        public float popFloat() {
            return this.num(Float::parseFloat).floatValue();
        }

        @Override
        public long popLong() {
            return this.num(Long::parseLong);
        }
    }

    private static final class ContextResolverContext
    extends ParamResolverContext
    implements ContextResolver.ContextResolverContext {
        public ContextResolverContext(List<String> input2, CommandActor actor, CommandParameter parameter, Object[] resolved) {
            super(input2, actor, parameter, resolved);
        }
    }

    private static abstract class ParamResolverContext
    implements ParameterResolver.ParameterResolverContext {
        private final List<String> input;
        private final CommandActor actor;
        private final CommandParameter parameter;
        private final Object[] resolved;

        @Override
        @NotNull
        public @Unmodifiable List<String> input() {
            return this.input;
        }

        @Override
        @NotNull
        public <A extends CommandActor> A actor() {
            return (A)this.actor;
        }

        @Override
        @NotNull
        public CommandParameter parameter() {
            return this.parameter;
        }

        @Override
        @NotNull
        public ExecutableCommand command() {
            return this.parameter.getDeclaringCommand();
        }

        @Override
        @NotNull
        public CommandHandler commandHandler() {
            return this.parameter.getCommandHandler();
        }

        @Override
        @NotNull
        public <T> T getResolvedParameter(@NotNull CommandParameter parameter) {
            try {
                return (T)this.resolved[parameter.getMethodIndex()];
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("This parameter has not been resolved yet!");
            }
        }

        @Override
        @NotNull
        public <T> T getResolvedArgument(@NotNull Class<T> type) {
            for (Object o : this.resolved) {
                if (!type.isInstance(o)) continue;
                return (T)o;
            }
            throw new IllegalArgumentException("This parameter has not been resolved yet!");
        }

        public ParamResolverContext(List<String> input2, CommandActor actor, CommandParameter parameter, Object[] resolved) {
            this.input = input2;
            this.actor = actor;
            this.parameter = parameter;
            this.resolved = resolved;
        }
    }
}

