/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import revxrsal.commands.CommandHandler;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandCategory;
import revxrsal.commands.command.CommandPermission;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.core.CommandExecutable;
import revxrsal.commands.core.CommandPath;

final class BaseCommandCategory
implements CommandCategory {
    CommandPath path;
    String name;
    @Nullable
    BaseCommandCategory parent;
    @Nullable
    CommandExecutable defaultAction;
    CommandHandler handler;
    final Map<CommandPath, ExecutableCommand> commands = new HashMap<CommandPath, ExecutableCommand>();
    final Map<CommandPath, BaseCommandCategory> categories = new HashMap<CommandPath, BaseCommandCategory>();
    final CommandPermission permission = new CategoryPermission();
    private final Map<CommandPath, CommandCategory> unmodifiableCategories = Collections.unmodifiableMap(this.categories);
    private final Map<CommandPath, ExecutableCommand> unmodifiableCommands = Collections.unmodifiableMap(this.commands);

    BaseCommandCategory() {
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public CommandPath getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public CommandHandler getCommandHandler() {
        return this.handler;
    }

    @Override
    @Nullable
    public CommandCategory getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public ExecutableCommand getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    @NotNull
    public CommandPermission getPermission() {
        return this.permission;
    }

    @Override
    public boolean isSecret() {
        for (ExecutableCommand executableCommand : this.commands.values()) {
            if (executableCommand.isSecret()) continue;
            return false;
        }
        for (CommandCategory commandCategory : this.categories.values()) {
            if (commandCategory.isSecret()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.defaultAction == null && this.commands.isEmpty() && this.categories.isEmpty();
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<CommandPath, CommandCategory> getCategories() {
        return this.unmodifiableCategories;
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<CommandPath, ExecutableCommand> getCommands() {
        return this.unmodifiableCommands;
    }

    public String toString() {
        return "CommandCategory{path=" + this.path + ", name='" + this.name + "'}";
    }

    public void parent(BaseCommandCategory cat) {
        this.parent = cat;
        if (cat != null) {
            cat.categories.put(this.path, this);
        }
    }

    @Override
    public int compareTo(@NotNull CommandCategory o) {
        return this.path.compareTo(o.getPath());
    }

    private class CategoryPermission
    implements CommandPermission {
        private CategoryPermission() {
        }

        @Override
        public boolean canExecute(@NotNull CommandActor actor) {
            for (ExecutableCommand executableCommand : BaseCommandCategory.this.commands.values()) {
                if (!executableCommand.getPermission().canExecute(actor)) continue;
                return true;
            }
            for (CommandCategory commandCategory : BaseCommandCategory.this.categories.values()) {
                if (!commandCategory.getPermission().canExecute(actor)) continue;
                return true;
            }
            return BaseCommandCategory.this.defaultAction == null || BaseCommandCategory.this.defaultAction.hasPermission(actor);
        }
    }
}

