/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import revxrsal.commands.CommandHandler;
import revxrsal.commands.autocomplete.AutoCompleter;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.autocomplete.SuggestionProviderFactory;
import revxrsal.commands.command.ArgumentStack;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.command.CommandCategory;
import revxrsal.commands.command.CommandParameter;
import revxrsal.commands.command.ExecutableCommand;
import revxrsal.commands.core.AutoCompleterAnnotationFactory;
import revxrsal.commands.core.BaseCommandHandler;
import revxrsal.commands.core.CommandPath;
import revxrsal.commands.core.EnumSuggestionProviderFactory;
import revxrsal.commands.core.MutableCommandPath;
import revxrsal.commands.util.Collections;
import revxrsal.commands.util.Preconditions;
import revxrsal.commands.util.Primitives;

final class BaseAutoCompleter
implements AutoCompleter {
    private final BaseCommandHandler handler;
    final Map<String, SuggestionProvider> suggestionKeys = new HashMap<String, SuggestionProvider>();
    final LinkedList<SuggestionProviderFactory> factories = new LinkedList();

    public BaseAutoCompleter(BaseCommandHandler handler2) {
        this.handler = handler2;
        this.registerSuggestion("nothing", SuggestionProvider.EMPTY);
        this.registerSuggestion("empty", SuggestionProvider.EMPTY);
        this.registerParameterSuggestions(Boolean.TYPE, SuggestionProvider.of("true", "false"));
        this.registerSuggestionFactory(new AutoCompleterAnnotationFactory(this.suggestionKeys));
    }

    @Override
    public AutoCompleter registerSuggestion(@NotNull String providerID, @NotNull SuggestionProvider provider2) {
        Preconditions.notNull(provider2, "provider ID");
        Preconditions.notNull(provider2, "tab suggestion provider");
        this.suggestionKeys.put(providerID, provider2);
        return this;
    }

    @Override
    public AutoCompleter registerSuggestion(@NotNull String providerID, @NotNull Collection<String> completions) {
        Preconditions.notNull(providerID, "provider ID");
        Preconditions.notNull(completions, "completions");
        this.suggestionKeys.put(providerID, (args2, sender, command2) -> completions);
        return this;
    }

    @Override
    public AutoCompleter registerSuggestion(@NotNull String providerID, String ... completions) {
        this.registerSuggestion(providerID, Collections.listOf(completions));
        return this;
    }

    @Override
    public AutoCompleter registerParameterSuggestions(@NotNull Class<?> parameterType, @NotNull SuggestionProvider provider2) {
        Preconditions.notNull(parameterType, "parameter type");
        Preconditions.notNull(provider2, "provider");
        this.registerSuggestionFactory(SuggestionProviderFactory.forType(parameterType, provider2));
        Class<?> wrapped = Primitives.wrap(parameterType);
        if (wrapped != parameterType) {
            this.registerSuggestionFactory(SuggestionProviderFactory.forType(wrapped, provider2));
        }
        return this;
    }

    @Override
    public AutoCompleter registerParameterSuggestions(@NotNull Class<?> parameterType, @NotNull String providerID) {
        Preconditions.notNull(parameterType, "parameter type");
        Preconditions.notNull(providerID, "provider ID");
        SuggestionProvider provider2 = this.suggestionKeys.get(providerID);
        if (provider2 == null) {
            throw new IllegalArgumentException("No such tab provider: " + providerID + ". Available: " + this.suggestionKeys.keySet());
        }
        this.registerParameterSuggestions(parameterType, provider2);
        return this;
    }

    @Override
    public AutoCompleter registerSuggestionFactory(@NotNull SuggestionProviderFactory factory) {
        Preconditions.notNull(factory, "suggestion provider factory cannot be null!");
        this.factories.add(factory);
        return this;
    }

    @Override
    public AutoCompleter registerSuggestionFactory(int priority, @NotNull SuggestionProviderFactory factory) {
        Preconditions.notNull(factory, "suggestion provider factory cannot be null!");
        this.factories.add(Preconditions.coerceIn(priority, 0, this.factories.size()), factory);
        return this;
    }

    public SuggestionProvider getProvider(CommandParameter parameter) {
        if (parameter.isSwitch()) {
            return SuggestionProvider.of(this.handler.switchPrefix + parameter.getSwitchName());
        }
        for (SuggestionProviderFactory factory : this.factories) {
            SuggestionProvider provider2 = factory.createSuggestionProvider(parameter);
            if (provider2 == null) continue;
            return provider2;
        }
        if (parameter.getType().isEnum()) {
            return EnumSuggestionProviderFactory.INSTANCE.createSuggestionProvider(parameter);
        }
        return SuggestionProvider.EMPTY;
    }

    @Override
    public SuggestionProvider getSuggestionProvider(@NotNull String id) {
        return this.suggestionKeys.get(id);
    }

    @Override
    public List<String> complete(@NotNull CommandActor actor, @NotNull ArgumentStack arguments) {
        CommandPath path = CommandPath.get(arguments.subList(0, arguments.size() - 1));
        int originalSize = arguments.size();
        ExecutableCommand command2 = this.searchForCommand(path, actor);
        if (command2 != null) {
            command2.getPath().forEach(c -> {
                String cfr_ignored_0 = (String)arguments.removeFirst();
            });
            return this.getCompletions(actor, arguments, command2);
        }
        CommandCategory category = this.getLastCategory(path);
        if (category == null) {
            return java.util.Collections.emptyList();
        }
        category.getPath().forEach(c -> {
            String cfr_ignored_0 = (String)arguments.removeFirst();
        });
        return this.getCompletions(actor, arguments, category, originalSize);
    }

    @Override
    public List<String> complete(@NotNull CommandActor actor, @NotNull String buffer) {
        return this.complete(actor, this.handler.parseArgumentsForCompletion(buffer));
    }

    private ExecutableCommand searchForCommand(CommandPath path, CommandActor actor) {
        ExecutableCommand found = this.handler.getCommand(path);
        if (found != null && !found.isSecret() && found.getPermission().canExecute(actor)) {
            return found;
        }
        MutableCommandPath mpath = MutableCommandPath.empty();
        for (String p : path) {
            mpath.add(p);
            found = this.handler.getCommand(mpath);
            if (found == null || found.isSecret() || !found.getPermission().canExecute(actor)) continue;
            return found;
        }
        return null;
    }

    private CommandCategory getLastCategory(CommandPath path) {
        MutableCommandPath mpath = MutableCommandPath.empty();
        CommandCategory category = null;
        for (String p : path) {
            mpath.add(p);
            CommandCategory c = this.handler.getCategory(mpath);
            if (c == null && category != null) {
                return category;
            }
            if (c == null) continue;
            category = c;
        }
        return category;
    }

    private List<String> getCompletions(CommandActor actor, ArgumentStack args2, @NotNull ExecutableCommand command2) {
        try {
            if (args2.isEmpty()) {
                return java.util.Collections.emptyList();
            }
            if (command2.getValueParameters().isEmpty()) {
                return java.util.Collections.emptyList();
            }
            ArrayList<CommandParameter> parameters2 = new ArrayList<CommandParameter>(command2.getValueParameters().values());
            java.util.Collections.sort(parameters2);
            for (CommandParameter parameter : parameters2) {
                try {
                    if (parameter.isFlag() || parameter.getCommandIndex() != args2.size() - 1) continue;
                    if (!parameter.getPermission().canExecute(actor)) {
                        return java.util.Collections.emptyList();
                    }
                    SuggestionProvider provider2 = parameter.getSuggestionProvider();
                    Preconditions.notNull(provider2, "provider must not be null!");
                    return this.getParamCompletions(provider2.getSuggestions(args2, actor, command2), args2);
                }
                catch (Throwable provider2) {
                }
            }
            parameters2.removeIf(c -> !c.isFlag());
            if (parameters2.isEmpty()) {
                return java.util.Collections.emptyList();
            }
            Optional<CommandParameter> currentFlag = parameters2.stream().filter(c -> {
                int index = args2.indexOf(this.handler.getFlagPrefix() + c.getFlagName());
                return index == args2.size() - 2;
            }).findFirst();
            if (currentFlag.isPresent()) {
                SuggestionProvider provider3 = currentFlag.get().getSuggestionProvider();
                return this.getParamCompletions(provider3.getSuggestions(args2, actor, command2), args2);
            }
            for (CommandParameter flag : parameters2) {
                int index = args2.indexOf(this.handler.getFlagPrefix() + flag.getFlagName());
                if (index == -1) {
                    return Collections.listOf(this.handler.getFlagPrefix() + flag.getFlagName());
                }
                if (index != args2.size() - 2) continue;
                return this.getParamCompletions(flag.getSuggestionProvider().getSuggestions(args2, actor, command2), args2);
            }
            return java.util.Collections.emptyList();
        }
        catch (IndexOutOfBoundsException e) {
            return java.util.Collections.emptyList();
        }
    }

    @NotNull
    private List<String> getParamCompletions(Collection<String> provider2, ArgumentStack args2) {
        return provider2.stream().filter(c -> c.toLowerCase().startsWith(((String)args2.getLast()).toLowerCase())).sorted(String.CASE_INSENSITIVE_ORDER).distinct().collect(Collectors.toList());
    }

    private List<String> getCompletions(CommandActor actor, @Unmodifiable ArgumentStack args2, CommandCategory category, int originalSize) {
        if (args2.isEmpty()) {
            return java.util.Collections.emptyList();
        }
        HashSet<String> suggestions = new HashSet<String>();
        if (category.getDefaultAction() != null) {
            suggestions.addAll(this.getCompletions(actor, args2, category.getDefaultAction()));
        }
        if (originalSize - category.getPath().size() == 1) {
            category.getCommands().values().forEach(c -> {
                if (!c.isSecret() && c.getPermission().canExecute(actor)) {
                    suggestions.add(c.getName());
                }
            });
            category.getCategories().values().forEach(c -> {
                if (!c.isSecret() && c.getPermission().canExecute(actor)) {
                    suggestions.add(c.getName());
                }
            });
        }
        return this.getParamCompletions(suggestions, args2);
    }

    @Override
    public CommandHandler and() {
        return this.handler;
    }
}

